/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  rsm_tsk.c
 * @brief 
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"


#if _KERNEL_SPT_ENA_TEX


/* %jp{^XNŐ֎~} */
ER ena_tex(void)
{
	_KERNEL_T_TSKHDL      tskhdl;
	_KERNEL_T_TCB         *tcb;

#if _KERNEL_SPT_ENA_TSK_E_CTX
	if ( _KERNEL_SYS_SNS_CTX() )
	{
		return E_CTX;
	}
#endif
	
	_KERNEL_ENTER_SVC();			/* %jp{enter service-call}%jp{T[rXR[ɓ} */
		

	/* %jp{s^XN擾} */
	tskhdl = _KERNEL_SYS_GET_RUNTSK();
	
	/* %jp{Rg[ubN擾} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	_KERNEL_TSK_SET_TEXSTAT(tcb, _KERNEL_TXS_ENA);
	
	_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */

	return E_OK;
}


#else	/* _KERNEL_SPT_ENA_TEX */


#if _KERNEL_SPT_ENA_TEX_E_NOSPT

ER ena_tex(void)
{
	return E_NOSPT;
}

#endif


#endif


/* end of file */
