/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  cre_tsk.c
 * @brief %jp{^XN̐}%en{Create Task}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"


#if _KERNEL_SPT_CRE_TSK


/** %jp{^XN̐}%en{Create Task}
 * @param  tskid	%jp{^XNID}%en{ID number of the task to be created}
 * @param  pk_ctsk	%jp{^XNꂽpPbgւ̃|C^}%en{Pointer to the packet containing the task creation information}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(tskids邢͎gpłȂ)}%en{Invalid ID number(tskid is invalid or unusable)}
 * @retval E_NOMEM	%jp{s}%en{Insufficient memory}
 * @retval E_PAR    %jp{p[^G[}%en{Perameter error}
 * @retval E_RSATR  %jp{\񑮐(tskatrs邢͎gpłȂ)}%en{Reserved attribute(tskatr is invalid or unusable)}
 */
ER cre_tsk(
		ID				tskid,
		const T_CTSK	*pk_ctsk)
{
	ER ercd;

	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{ID`FbN}%en{check ID} */
#if _KERNEL_SPT_CRE_TSK_E_ID
	if ( _KERNEL_TSK_CHECK_EXS(tskid) )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
		return E_OBJ;				/* %jp{IDԍs} */
	}
#endif
	
	/* %jp{^XN} */
	ercd = _kernel_cre_tsk(tskid, pk_ctsk);

	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
	
	return ercd;	/*  */
}


#else	/* _KERNEL_SPT_CRE_TSK */


#if _KERNEL_SPT_CRE_TSK_E_NOSPT

/** %jp{^XN̐}%en{Create Task}
 * @param  tskid	%jp{^XNID}%en{ID number of the task to be created}
 * @param  pk_ctsk	%jp{^XNꂽpPbgւ̃|C^}%en{Pointer to the packet containing the task creation information}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER cre_tsk(
		ID				tskid,
		const T_CTSK	*pk_ctsk)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_CRE_TSK */



/* end of file */
