/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_mtx.c
 * @brief %jp{~[ebNX̐(IDԍt)}%en{Create Mutex(ID Number Automatic Assignment)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mtxobj.h"



#if _KERNEL_SPT_ACRE_MTX

/** %jp{~[ebNX̐(IDԍt)}%en{Create Mutex(ID Number Automatic Assignment)}
 * @param  pk_cmtx	      %jp{~[ebNXꂽpPbgւ̃|C^}%en{Pointer to the packet containing the mutex creation information}
 * @retval %jp{̒l}%en{positiv-value} %jp{~[ebNXIDԍ}%en{ID number of the created mutex}
 * @retval E_NOID  %jp{IDԍs(t\ȃ~[ebNXID)}%en{No ID number available(there id no mutex ID assignable)}
 * @retval E_RSATR %jp{\񑮐(mtxatrs邢͎gpłȂ)}%en{Reserved attribute(mtxatr is invalid or unusable)}
 */
ER_ID acre_mtx(const T_CMTX *pk_cmtx)
{
	ID    mtxid;
	ER_ID erid;

	/* %jp{`FbN}%en{check attribute} */
#if _KERNEL_SPT_ACRE_MTX_E_RSATR
	if ( ((pk_cmtx->mtxatr & TA_TPRI) == 0 && !_KERNEL_SPT_MTX_TA_TFIFO)
		|| ((pk_cmtx->mtxatr & TA_TPRI) != 0 && !_KERNEL_SPT_MTX_TA_TPRI) )
	{
		return E_RSATR;	/* %jp{\񑮐}%en{Reserved attribute} */
	}
#endif

	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{IDT} */
	for ( mtxid = _KERNEL_MTX_TMAX_ID; mtxid >= _KERNEL_MTX_TMIN_ID; mtxid-- )
	{
		if ( !_KERNEL_MTX_CHECK_EXS(mtxid) )
		{
			break;
		}
	}

	/* %jp{IDT`FbN} */
#if _KERNEL_SPT_ACRE_MTX_E_NOID
	if ( mtxid < _KERNEL_MTX_TMIN_ID )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOID;			/* %jp{IDԍs} */
	}
#endif
	
	/* %jp{IuWFNg} */
#if (_KERNEL_MTXCB_ALGORITHM == _KERNEL_MTXCB_ALG_PTRARRAY) && _KERNEL_SPT_ACRE_MTX_E_NOMEM
	erid = (ER_ID)_kernel_cre_mtx(mtxid, pk_cmtx);
	if ( erid == E_OK )
	{
		erid = (ER_ID)mtxid;	/* %jp{G[łȂ΃~[ebNXIDi[} */
	}
#else
	_kernel_cre_mtx(mtxid, pk_cmtx);
	erid = (ER_ID)mtxid;		/* %jp{~[ebNXIDi[} */
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
	
	return erid;
}


#else	/* _KERNEL_SPT_ACRE_MTX */


#if _KERNEL_SPT_ACRE_MTX_E_NOSPT


/** %jp{~[ebNX̐(IDԍt)}%en{Create Mutex(ID Number Automatic Assignment)}
 * @param  pk_cmtx  %jp{~[ebNXꂽpPbgւ̃|C^}%en{Pointer to the packet containing the mutex creation information}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER_ID acre_mtx(const T_CMTX *pk_cmtx)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_ACRE_MTX */



/* end of file */
