/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_mpf.c
 * @brief %jp{Œ蒷v[̐(IDԍt)}%en{Create fixed-sized memory pool(ID Number Automatic Assignment)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mpfobj.h"



#if _KERNEL_SPT_ACRE_MPF

/** %jp{Œ蒷v[̐(IDԍt)}%en{Create fixed-sized memory pool(ID Number Automatic Assignment)}
 * @param  pk_cmpf	      %jp{Œ蒷v[ꂽpPbgւ̃|C^}%en{Pointer to the packet containing the fixed-sized memory pool creation information}
 * @retval %jp{̒l}%en{positiv-value} %jp{Œ蒷v[IDԍ}%en{ID number of the created fixed-sized memory pool}
 * @retval E_NOID  %jp{IDԍs(t\ȌŒ蒷v[ID)}%en{No ID number available(there id no fixed-sized memory pool ID assignable)}
 * @retval E_RSATR %jp{\񑮐(mpfatrs邢͎gpłȂ)}%en{Reserved attribute(mpfatr is invalid or unusable)}
 */
ER_ID acre_mpf(const T_CMPF *pk_cmpf)
{
	ID    mpfid;
	ER_ID erid;

	/* %jp{`FbN}%en{check attribute} */
#if _KERNEL_SPT_ACRE_MPF_E_RSATR
	if ( ((pk_cmpf->mpfatr & TA_TPRI) == 0 && !_KERNEL_SPT_MPF_TA_TFIFO)
		|| ((pk_cmpf->mpfatr & TA_TPRI) != 0 && !_KERNEL_SPT_MPF_TA_TPRI) )
	{
		return E_RSATR;	/* %jp{\񑮐}%en{Reserved attribute} */
	}
#endif

	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{IDT} */
	for ( mpfid = _KERNEL_MPF_TMAX_ID; mpfid >= _KERNEL_MPF_TMIN_ID; mpfid-- )
	{
		if ( !_KERNEL_MPF_CHECK_EXS(mpfid) )
		{
			break;
		}
	}

	/* %jp{IDT`FbN} */
#if _KERNEL_SPT_ACRE_MPF_E_NOID
	if ( mpfid < _KERNEL_MPF_TMIN_ID )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOID;			/* %jp{IDԍs} */
	}
#endif
	
	/* %jp{IuWFNg} */
#if (_KERNEL_MPFCB_ALGORITHM == _KERNEL_MPFCB_ALG_PTRARRAY) && _KERNEL_SPT_ACRE_MPF_E_NOMEM
	erid = (ER_ID)_kernel_cre_mpf(mpfid, pk_cmpf);
	if ( erid == E_OK )
	{
		erid = (ER_ID)mpfid;	/* %jp{G[łȂΌŒ蒷v[IDi[} */
	}
#else
	_kernel_cre_mpf(mpfid, pk_cmpf);
	erid = (ER_ID)mpfid;		/* %jp{Œ蒷v[IDi[} */
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
	
	return erid;
}


#else	/* _KERNEL_SPT_ACRE_MPF */


#if _KERNEL_SPT_ACRE_MPF_E_NOSPT


/** %jp{Œ蒷v[̐(IDԍt)}%en{Create Semaphore(ID Number Automatic Assignment)}
 * @param  pk_cmpf  %jp{Œ蒷v[ꂽpPbgւ̃|C^}%en{Pointer to the packet containing the mpfaphore creation information}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER_ID acre_mpf(const T_CMPF *pk_cmpf)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_ACRE_MPF */



/* end of file */
