/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  kadp_msg.c
 * @brief %jp{DxL[ɃbZ[Wǉ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/mbxobj.h"



/** %jp{DxL[ɃbZ[Wǉ} */
void _kernel_adp_msg(_KERNEL_T_MBXCB_PTR mbxcb, T_MSG *pk_msg)
{
	_KERNEL_MBX_T_MPRI mpri;
	T_MSG              ***pppk_msgque;

	/* %jp{bZ[WL[̔zƂĎ擾} */
	pppk_msgque = (T_MSG ***)_KERNEL_MBX_GET_MSGQUE(mbxcb);

	/* %jp{bZ[WDx擾} */
	mpri = ((T_MSG_PRI *)pk_msg)->msgpri;

	/* %jp{bZ[Wǉ} */
	_kernel_add_msq(&(*pppk_msgque)[mpri - TMIN_MPRI], pk_msg);
}



/* end of file */
