/**
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_mbx.c
 * @brief %jp{[{bNX̐(IDԍt)}%en{Create Mailbox(ID Number Automatic Assignment)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mbxobj.h"



#if _KERNEL_SPT_ACRE_MBX


/** %jp{[{bNX̐(IDԍt)}%en{Create Mailbox(ID Number Automatic Assignment)}
 * @param  pk_cmbx	      %jp{[{bNXꂽpPbgւ̃|C^}%en{Pointer to the packet containing the mailbox creation information}
 * @retval %jp{̒l}%en{positiv-value} %jp{[{bNXIDԍ}%en{ID number of the created mailbox}
 * @retval E_NOID  %jp{IDԍs(t\ȃ[{bNXID)}%en{No ID number available(there id no mailbox ID assignable)}
 * @retval E_RSATR %jp{\񑮐(mbxatrs邢͎gpłȂ)}%en{Reserved attribute(mbxatr is invalid or unusable)}
 */
ER_ID acre_mbx(const T_CMBX *pk_cmbx)
{
	ID    mbxid;
	ER_ID erid;
	
	/* %jp{`FbN}%en{check attribute} */
#if _KERNEL_SPT_ACRE_MBX_E_RSATR
	if ( ((pk_cmbx->mbxatr & TA_TPRI) == 0 && !_KERNEL_SPT_MBX_TA_TFIFO)
		|| ((pk_cmbx->mbxatr & TA_TPRI) != 0 && !_KERNEL_SPT_MBX_TA_TPRI)
		|| ((pk_cmbx->mbxatr & TA_MPRI) == 0 && !_KERNEL_SPT_MBX_TA_MFIFO)
		|| ((pk_cmbx->mbxatr & TA_MPRI) != 0 && !_KERNEL_SPT_MBX_TA_MPRI) )
	{
		return E_RSATR;	/* %jp{\񑮐}%en{Reserved attribute} */
	}
#endif

	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{IDT} */
	for ( mbxid = _KERNEL_MBX_TMAX_ID; mbxid >= _KERNEL_MBX_TMIN_ID; mbxid-- )
	{
		if ( !_KERNEL_MBX_CHECK_EXS(mbxid) )
		{
			break;
		}
	}

	/* %jp{IDT`FbN} */
#if _KERNEL_SPT_ACRE_SEM_E_NOID
	if ( mbxid < _KERNEL_MBX_TMIN_ID )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOID;				/* %jp{IDԍs}%en{No ID number available} */
	}
#endif
	
	/* %jp{[{bNX} */
	erid = (ER_ID)_kernel_cre_mbx(mbxid, pk_cmbx);
	if ( erid == E_OK )
	{
		erid = (ER_ID)mbxid;
	}

	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
	
	return erid;
}


#else	/* _KERNEL_SPT_ACRE_MBX */


#if _KERNEL_SPT_ACRE_MBX_E_NOSPT

/** %jp{[{bNX̐(IDԍt)}%en{Create Eventflag(ID Number Automatic Assignment)}
 * @param  pk_cmbx	%jp{[{bNXꂽpPbgւ̃|C^}%en{Pointer to the packet containing the eventflag creation information}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER_ID acre_mbx(const T_CMBX *pk_cmbx)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_ACRE_MBX */



/* end of file */
