/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  iset_flg.c
 * @brief %jp{CxgtÕZbg}%en{Set Eventflag}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"


#if _KERNEL_SPT_ISET_FLG

#if _KERNEL_SPT_DPC

static void _kernel_dpc_set_flg(ID flgid, VP_INT param);

/** %jp{CxgtÕZbg}%en{Set Eventflag}
 * @param  flgid    %jp{ZbgΏۂ̃CxgtOIDԍ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{Zbgrbgp^[}%en{Bit pattern to set}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(flgids邢͎gpłȂ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_NOMEM  %jp{xsp̃L[COs}%en{Insufficient memory to store a service call for delayed execution}
 */
ER iset_flg(ID flgid, FLGPTN setptn)
{
	/* %jp{ID ̃`FbN} */
#if _KERNEL_SPT_ISET_FLG_E_ID
	if ( !_KERNEL_FLG_CHECK_FLGID(flgid) )
	{
		return E_ID;		/* %jp{IDs} */
	}
#endif

	return _KERNEL_SYS_REQ_DPC(_kernel_dpc_set_flg, flgid, (VP_INT)setptn);
}


/** %jp{set_flg̒xs}%en{service call for delayed execution(set_flg)} */
void _kernel_dpc_set_flg(ID flgid, VP_INT param)
{
	_KERNEL_T_QUE    *pk_que;
	_KERNEL_T_FLGCB  *flgcb;
	_KERNEL_T_FLGINF *pk_flginf;
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TSKHDL tskhdl_next;
	_KERNEL_T_TCB    *tcb;
	FLGPTN           setptn;
	
	/* %jp{p[^ϊ} */
	setptn = (FLGPTN) param;
	
	
	/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_ISET_FLG_E_NOEXS
	if ( !_KERNEL_FLG_CHECK_EXS(flgid) )
	{
		return;			/* %jp{IuWFNg} */
	}
#endif

	/* %jp{Rg[ubN擾} */
	flgcb = _KERNEL_FLG_ID2FLGCB(flgid);

	/* %jp{҂s擾} */
	pk_que = _KERNEL_FLG_GET_QUE(flgcb);
	
	/* %jp{tOZbg} */
	_KERNEL_FLG_SET_FLGPTN(flgcb, _KERNEL_FLG_GET_FLGPTN(flgcb) | setptn);

	/* %jp{҂^XN΋N`FbN} */
	tskhdl = _KERNEL_REF_QUE(pk_que);
	while ( tskhdl != _KERNEL_TSKHDL_NULL )
	{
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);					/* %jp{TCB擾} */

		tskhdl_next = _KERNEL_NXT_QUE(pk_que, tskhdl);			/* %jp{̑҂^XN擾} */

		/* %jp{tO`FbN} */
		pk_flginf = (_KERNEL_T_FLGINF *)_KERNEL_TSK_GET_DATA(tcb);
		if ( _kernel_chk_flg(flgcb, pk_flginf) )
		{
			/* %jp{N𖞂ĂȂ} */
			pk_flginf->waiptn = _KERNEL_FLG_GET_FLGPTN(flgcb);	/* %jp{݂̃tOp^[i[} */
			
			/* %jp{҂} */
			_KERNEL_TSK_SET_ERCD(tcb, E_OK);		/* %jp{G[R[hݒ} */
			_KERNEL_RMV_QUE(pk_que, tskhdl);		/* %jp{҂s񂩂O} */
			_KERNEL_FLG_RMV_TOQ(tskhdl);			
			_KERNEL_DSP_WUP_TSK(tskhdl);			/* %jp{^XN̑҂} */
			
			/* %jp{҂}[N} */
			_KERNEL_SYS_SET_DLY();

#if _KERNEL_SPT_FLG_TA_CLR
			{
				const _KERNEL_T_FLGCB_RO *flgcb_ro;
				flgcb_ro = _KERNEL_FLG_GET_FLGCB_RO(flgid, flgcb);

				if ( _KERNEL_FLG_GET_FLGATR(flgcb_ro) & TA_CLR )
				{
					_KERNEL_FLG_SET_FLGPTN(flgcb, 0);			/* %jp{NA΃NA} */
					break;
				}
			}
#endif
		}
		tskhdl = tskhdl_next;	/* ̃^XNɐi߂ */
	}
}

#else	/* _KERNEL_SPT_DPC */

/** %jp{CxgtO̕ԋp}%en{Release Flgaphore Resource}
 * @param  flgid    %jp{CxgtOԋpΏۂ̃CxgtOIDԍ}%en{ID number of the Eventflag to which resource is released}
 */
ER iset_flg(ID flgid, FLGPTN setptn)
{
	return set_flg(flgid, setptn);
}

#endif	/* _KERNEL_SPT_DPC */


#else	/* _KERNEL_SPT_SET_FLG */


#if _KERNEL_SPT_ISET_FLG_E_NOSPT

/** %jp{CxgtO̕ԋp}%en{Release Flgaphore Resource}
 * @param  flgid    %jp{CxgtOԋpΏۂ̃CxgtOIDԍ}%en{ID number of the Eventflag to which resource is released}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER iset_flg(ID flgid, FLGPTN setptn)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_SET_FLG */



/* end of file */
