/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  del_flg.c
 * @brief %jp{CxgtO̍폜}%en{Delete Eventflag}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/flgobj.h"



#if _KERNEL_SPT_DEL_FLG


/** %jp{CxgtO̍폜}%en{Delete Eventflag}
 * @param  flgid    %jp{폜Ώۂ̃CxgtOIDԍ}%en{ID number of the eventflag to be deleted}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(flgids邢͎gpłȂ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_NOEXS  %jp{IuWFNg(ΏۃCxgtOo^)}%en{Non-existant object(specified eventflag is not registerd)}
 */
ER del_flg(ID flgid)
{
	_KERNEL_T_FLGCB  *flgcb;
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;
	_KERNEL_T_QUE    *pk_que;;

	/* %jp{ID`FbN}%en{check ID} */
#if _KERNEL_SPT_DEL_FLG_E_ID
	if ( !_KERNEL_FLG_CHECK_FLGID(flgid) )
	{
		return E_ID;	/* %jp{sIDԍ}%en{Invalid ID number} */
	}	
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{݃`FbN}%en{check object} */
#if _KERNEL_SPT_DEL_FLG_E_NOEXS
	if ( !_KERNEL_FLG_CHECK_EXS(flgid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOEXS;	
	}
#endif
	
	/* %jp{Rg[ubN擾} */
	flgcb = _KERNEL_FLG_ID2FLGCB(flgid);
	
	/* %jp{҂s擾} */
	pk_que = _KERNEL_FLG_GET_QUE(flgcb);
	
	/* %jp{҂s̃^XNSċN} */
	while ( (tskhdl = _KERNEL_RMH_QUE(pk_que)) != _KERNEL_TSKHDL_NULL )
	{
		/* %jp{҂^XNΑ҂} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);	/* %jp{TCB擾} */
		_KERNEL_TSK_SET_ERCD(tcb, E_DLT);		/* %jp{G[R[hݒ} */
		_KERNEL_FLG_RMV_TOQ(tskhdl);			/* %jp{^CAEgL[O} */
		_KERNEL_DSP_WUP_TSK(tskhdl);			/* %jp{^XN̑҂} */	
	}
	
	/* %jp{IuWFNg폜} */
#if _KERNEL_FLGCB_ALGORITHM == _KERNEL_FLGCB_ALG_PTRARRAY
	_KERNEL_SYS_FRE_HEP(_KERNEL_FLG_ID2FLGCB(flgid));	/* %jp{J} */
	_KERNEL_FLG_ID2FLGCB(flgid) = NULL;
#elif _KERNEL_FLGCB_ALGORITHM == _KERNEL_FLGCB_ALG_BLKARRAY
	_KERNEL_FLG_SET_FLGATR(flgcb, 0);					/* %jp{폜}[N} */
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
	
	return E_OK;
}


#else	/* _KERNEL_SPT_DEL_FLG */


#if _KERNEL_SPT_DEL_FLG_E_NOSPT

/** %jp{CxgtO̍폜}%en{Delete Eventflag}
 * @param  flgid    %jp{폜Ώۂ̃CxgtOIDԍ}%en{ID number of the eventflag to be deleted}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER del_flg(ID flgid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_DEL_FLG */



/* end of file */
