/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  prcv_dtq.c
 * @brief %jp{f[^L[ւ̑M(|[O)}%en{Send to Data Queue(Polling)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/dtqobj.h"



#if _KERNEL_SPT_PRCV_DTQ


/** %jp{f[^L[ւ̑M(|[O)}%en{Send to Data Queue(Polling)} */
ER prcv_dtq(ID dtqid, VP_INT *p_data)
{
	_KERNEL_T_DTQCB				*dtqcb;
	const _KERNEL_T_DTQCB_RO	*dtqcb_ro;
	_KERNEL_T_TSKHDL			tskhdl;
	_KERNEL_T_TCB				*tcb;
	_KERNEL_DTQ_T_DTQCNT		sdtqcnt;
	ER							ercd;


	/* %jp{ReLXg`FbN} */
#if _KERNEL_SPT_PRCV_DTQ_E_CTX
	if ( _KERNEL_SYS_SNS_DPN() )
	{
		return E_CTX;			/* %jp{ReLXgG[}%en{Context error} */
	}
#endif

	/* %jp{ID ̃`FbN} */
#if _KERNEL_SPT_PRCV_DTQ_E_ID
	if ( !_KERNEL_DTQ_CHECK_DTQID(dtqid) )
	{
		return E_ID;	/* %jp{sIDԍ}%en{Invalid ID number} */
	}
#endif

	_KERNEL_ENTER_SVC();	/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{IuWFNg݃`FbN} */
#if _KERNEL_SPT_PRCV_DTQ_E_NOEXS
	if ( !_KERNEL_DTQ_CHECK_EXS(dtqid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[I} */
		return E_NOEXS;			/* %jp{IuWFNg} */
	}
#endif
	
	/* %jp{f[^L[Rg[ubN擾} */
	dtqcb = _KERNEL_DTQ_ID2DTQCB(dtqid);
	
	/* %jp{M҂s擪^XNo} */
	tskhdl = _KERNEL_DTQ_RMH_SQUE(dtqcb);
	if ( tskhdl != _KERNEL_TSKHDL_NULL )
	{
		/* %jp{҂^XNΑ҂} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);		/* %jp{TCB擾} */
		
		/* %jp{^XNN} */
		_KERNEL_TSK_SET_ERCD(tcb, E_OK);	/* %jp{G[R[hݒ} */
		_KERNEL_DSP_WUP_TSK(tskhdl);		/* %jp{^XN̑҂} */
		_KERNEL_DTQ_RMV_STOQ(tskhdl);		/* %jp{^CAEgL[͂} */
	}
	
	
#if _KERNEL_SPT_DTQ_DTQCNT_NONZERO		/* %jp{f[^L[擾} */
	sdtqcnt = _KERNEL_DTQ_GET_SDTQCNT(dtqcb);
	if ( sdtqcnt > 0 )		/* %jp{L[Ƀf[^͂邩H} */
	{
		_KERNEL_DTQ_T_DTQCNT		dtqcnt;
		VP_INT						*dtq;
		_KERNEL_DTQ_T_DTQCNT		head;
		
		/* %jp{RO擾} */
		dtqcb_ro = _KERNEL_DTQ_GET_DTQCB_RO(dtqid, dtqcb);
		
		/* %jp{f[^L[擾} */
		dtq = _KERNEL_DTQ_GET_DTQ(dtqcb_ro);
		
		/* %jp{L[f[^o} */
		head   = _KERNEL_DTQ_GET_HEAD(dtqcb);
		dtqcnt = _KERNEL_DTQ_GET_DTQCNT(dtqcb_ro);
		*p_data = dtq[head];
		
		/* %jp{M҂^XN΃f[^ǉ} */
		if ( tskhdl != _KERNEL_TSKHDL_NULL )
		{
			/* %jp{Mf[^i[} */
			tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);		/* %jp{TCB擾} */
			dtq[head] = (VP_INT)_KERNEL_TSK_GET_DATA(tcb);
		}
		else
		{
			/* %jp{M҂΃L[̃f[^} */
			sdtqcnt--;
			_KERNEL_DTQ_SET_SDTQCNT(dtqcb, sdtqcnt);
		}
		
		/* %jp{擪ʒu炷} */
		if ( head + 1 < dtqcnt )
		{
			head++;
		}
		else
		{
			head = 0;
		}
		_KERNEL_DTQ_SET_HEAD(dtqcb, head);

		if ( tskhdl != _KERNEL_TSKHDL_NULL )
		{
			/* %jp{^XNfBXpb`̎s} */
			_KERNEL_DSP_TSK();
		}
		
		ercd = E_OK;	/* %jp{I}%en{Normal completion} */
	}
	else
#endif
	{
#if _KERNEL_SPT_DTQ_DTQCNT_ZERO
		if ( tskhdl != _KERNEL_TSKHDL_NULL )
		{
			/* %jp{Mf[^擾} */
			tcb     = _KERNEL_TSK_TSKHDL2TCB(tskhdl);		/* %jp{TCB擾} */
			*p_data = (VP_INT)_KERNEL_TSK_GET_DATA(tcb);	/* %jp{Mf[^i[} */

			/* %jp{^XNfBXpb`̎s} */
			_KERNEL_DSP_TSK();

			ercd = E_OK;		/* %jp{I}%en{Normal completion} */
		}
		else
#endif
		{
			ercd = E_TMOUT;		/* %jp{^CAEg} */
		}		
	}
		
	_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
	
	return ercd;
}


#else	/* _KERNEL_SPT_PRCV_DTQ */


#if _KERNEL_SPT_PRCV_DTQ_E_NOSPT

/** %jp{f[^L[ւ̑M(|[O)}%en{Send to Data Queue(Polling)} */
ER prcv_dtq(ID dtqid, VP_INT data)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_PRCV_DTQ */



/* end of file */
