/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  cre_dtq.c
 * @brief %jp{f[^L[̐}%en{Create Data queue}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/dtqobj.h"



#if _KERNEL_SPT_CRE_DTQ


/** %jp{f[^L[̐}%en{Create Data queue}
 * @param  dtqid    %jp{Ώۂ̃f[^L[IDԍ}%en{ID number of the data queue to be created}
 * @param  pk_ctsk	%jp{f[^L[ꂽpPbgւ̃|C^}%en{Pointer to the packet containing the data queue creation information}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(dtqids邢͎gpłȂ)}%en{Invalid ID number(dtqid is invalid or unusable)}
 * @retval E_RSATR  %jp{\񑮐(dtqatrs邢͎gpłȂ)}%en{Reserved attribute(dtqatr is invalid or unusable)}
 * @retval E_OBJ    %jp{IuWFNgԃG[(Ώۃf[^L[o^ς)}%en{Object state error(specified data queue is already registerd)}
 */
ER cre_dtq(ID dtqid, const T_CDTQ *pk_cdtq)
{
	ER ercd;

	/* %jp{ID`FbN}%en{check ID} */
#if _KERNEL_SPT_CRE_DTQ_E_ID
	if ( !_KERNEL_DTQ_CHECK_DTQID(dtqid) )
	{
		return E_ID;	/* %jp{sIDԍ}%en{Invalid ID number} */
	}	
#endif

	/* %jp{`FbN}%en{check attribute} */
#if _KERNEL_SPT_CRE_DTQ_E_RSATR
	if ( ((pk_cdtq->dtqatr & TA_TPRI) == 0 && !_KERNEL_SPT_DTQ_TA_TFIFO)
		|| ((pk_cdtq->dtqatr & TA_TPRI) != 0 && !_KERNEL_SPT_DTQ_TA_TPRI) )
	{
		return E_RSATR;	/* %jp{\񑮐}%en{Reserved attribute} */
	}
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{݃`FbN}%en{check object} */
#if _KERNEL_SPT_CRE_DTQ_E_OBJ
	if ( _KERNEL_DTQ_CHECK_EXS(dtqid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
		return E_OBJ;			/* %jp{IuWFNgԃG[}%en{Object state error} */
	}
#endif
	
	/* %jp{IuWFNg}%en{create object} */
	ercd = _kernel_cre_dtq(dtqid, pk_cdtq);
	
	_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
	
	return ercd;
}


#else	/* _KERNEL_SPT_CRE_DTQ */


#if _KERNEL_SPT_CRE_DTQ_E_NOSPT

/** %jp{f[^L[̐}%en{Create Data queue}
 * @param  dtqid    %jp{Ώۂ̃f[^L[IDԍ}%en{ID number of the data queue to be created}
 * @param  pk_ctsk	%jp{f[^L[ꂽpPbgւ̃|C^}%en{Pointer to the packet containing the data queue creation information}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER cre_dtq(ID dtqid, const T_CDTQ *pk_cdtq)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_CRE_DTQ */



/* end of file */
