/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_cyc.c
 * @brief %en{Activate Task}%jp{^XN̋N}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/cycobj.h"


/** %jp{nh}%en{Cyclic Handler} */
void _kernel_cyc_hdr(_KERNEL_T_TIMOBJ *pk_timobj, RELTIM ovrtim)
{
	_KERNEL_T_CYCCB_PTR    cyccb;
	_KERNEL_T_CYCCB_RO_PTR cyccb_ro;
	_KERNEL_CYC_T_CYCHDR   cychdr;
	_KERNEL_CYC_T_EXINF    exinf;
    _KERNEL_CYC_T_RELTIM   cyctim;

	cyccb    = (_KERNEL_T_CYCCB_PTR)pk_timobj;
	cyccb_ro = _KERNEL_CYC_GET_CYCCB_RO(_KERNEL_CYC_CYCCB2ID(cyccb), cyccb);
	
	cychdr = _KERNEL_CYC_GET_CYCHDR(cyccb_ro);
	exinf  = _KERNEL_CYC_GET_EXINF(cyccb_ro);
	cyctim = _KERNEL_CYC_GET_CYCTIM(cyccb_ro);

	for ( ; ; )
	{
		/* %jp{ nhĂяo} */
		cychdr(exinf);

		/* %jp{ nhŎg~Ă珈ł؂} */
		if ( !_KERNEL_SYS_BSY_TMQ(pk_timobj) )
		{

			break;
			return;	
		}
		
		/* %jp{ȏticiłꍇ͕nhĂ} */
		if ( ovrtim < cyctim )
		{
			break;
		}
		ovrtim -= cyctim;
	}
	
	/* %jp{̎ݒ} */
	_KERNEL_TIMOBJ_SET_LEFTTIM(pk_timobj, cyctim - ovrtim);
}


/* end of file */
