/**
 *  Hyper Operating System V4 Advance
 *
 * @file  del_cyc.c
 * @brief %jp{nh̍폜}%en{Delete cyclic handler}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/cycobj.h"



#if _KERNEL_SPT_DEL_CYC


/** %jp{nh̍폜}%en{Delete cyclic handler}
 * @param  cycid    %jp{폜Ώۂ̎nhIDԍ}%en{ID number of the cyclic handler to be deleted}
 * @retval E_OK     %jp{I}%en{Normal completion}
 * @retval E_ID     %jp{sIDԍ(cycids邢͎gpłȂ)}%en{Invalid ID number(cycid is invalid or unusable)}
 * @retval E_NOEXS  %jp{IuWFNg(Ώێnho^)}%en{Non-existant object(specified cyclic handler is not registerd)}
 */
ER del_cyc(ID cycid)
{
	_KERNEL_T_CYCCB  *cyccb;

	/* %jp{ID`FbN}%en{check ID} */
#if _KERNEL_SPT_DEL_CYC_E_ID
	if ( !_KERNEL_CYC_CHECK_CYCID(cycid) )
	{
		return E_ID;	/* %jp{sIDԍ}%en{Invalid ID number} */
	}
#endif

	_KERNEL_ENTER_SVC();	/* %jp{T[rXR[ɓ}%en{enter service-call} */

	/* %jp{݃`FbN}%en{check object} */
#if _KERNEL_SPT_DEL_CYC_E_NOEXS
	if ( !_KERNEL_CYC_CHECK_EXS(cycid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOEXS;
	}
#endif

	/* %jp{nhRg[ubN擾} */
	cyccb = _KERNEL_CYC_ID2CYCCB(cycid);

	/* %jp{IuWFNg폜} */
#if _KERNEL_CYCCB_ALGORITHM == _KERNEL_CYCCB_ALG_PTRARRAY
	_KERNEL_SYS_FRE_HEP(cyccb);						/* %jp{J} */
	_KERNEL_CYC_ID2CYCCB(cycid) = NULL;
#elif _KERNEL_CYCCB_ALGORITHM == _KERNEL_CYCCB_ALG_BLKARRAY
	_KERNEL_CYC_SET_MAXCYC(cyccb, 0);
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */

	return E_OK;
}


#else	/* _KERNEL_SPT_DEL_CYC */


#if _KERNEL_SPT_DEL_CYC_E_NOSPT

/** %jp{nh̍폜}%en{Delete cyclic handler}
 * @param  cycid    %jp{폜Ώۂ̎nhIDԍ}%en{ID number of the cyclic handler to be deleted}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER del_cyc(ID cycid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_DEL_cyc */



/* end of file */
