/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_cyc.c
 * @brief %jp{nh̐(IDԍt)}%en{Create cyclic handler(ID Number Automatic Assignment)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/cycobj.h"



#if _KERNEL_SPT_ACRE_CYC

/** %jp{nh̐(IDԍt)}%en{Create cyclic handler(ID Number Automatic Assignment)}
 * @param  pk_ccyc	      %jp{nhꂽpPbgւ̃|C^}%en{Pointer to the packet containing the cyclic handler creation information}
 * @retval %jp{̒l}%en{positiv-value} %jp{nhIDԍ}%en{ID number of the created cyclic handler}
 * @retval E_NOID  %jp{IDԍs(t\ȎnhID)}%en{No ID number available(there id no cyclic handler ID assignable)}
 * @retval E_RSATR %jp{\񑮐(cycatrs邢͎gpłȂ)}%en{Reserved attribute(cycatr is invalid or unusable)}
 */
ER_ID acre_cyc(const T_CCYC *pk_ccyc)
{
	ID    cycid;
	ER_ID erid;

	/* %jp{`FbN}%en{check attribute} */
#if _KERNEL_SPT_ACRE_CYC_E_RSATR
	if ( ((pk_ccyc->cycatr & TA_TPRI) == 0 && !_KERNEL_SPT_CYC_TA_TFIFO)
		|| ((pk_ccyc->cycatr & TA_TPRI) != 0 && !_KERNEL_SPT_CYC_TA_TPRI) )
	{
		return E_RSATR;	/* %jp{\񑮐}%en{Reserved attribute} */
	}
#endif

	_KERNEL_ENTER_SVC();		/* %jp{T[rXR[ɓ}%en{enter service-call} */
	
	/* %jp{IDT} */
	for ( cycid = _KERNEL_CYC_TMAX_ID; cycid >= _KERNEL_CYC_TMIN_ID; cycid-- )
	{
		if ( !_KERNEL_CYC_CHECK_EXS(cycid) )
		{
			break;
		}
	}

	/* %jp{IDT`FbN} */
#if _KERNEL_SPT_ACRE_CYC_E_NOID
	if ( cycid < _KERNEL_CYC_TMIN_ID )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{T[rXR[o}%en{leave service-call} */
		return E_NOID;			/* %jp{IDԍs} */
	}
#endif
	
	/* %jp{IuWFNg} */
#if (_KERNEL_CYCCB_ALGORITHM == _KERNEL_CYCCB_ALG_PTRARRAY) && _KERNEL_SPT_ACRE_CYC_E_NOMEM
	erid = (ER_ID)_kernel_cre_cyc(cycid, pk_ccyc);
	if ( erid == E_OK )
	{
		erid = (ER_ID)cycid;	/* %jp{G[łȂΎnhIDi[} */
	}
#else
	_kernel_cre_cyc(cycid, pk_ccyc);
	erid = (ER_ID)cycid;		/* %jp{nhIDi[} */
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{T[rXR[o}%en{leave service-call} */
	
	return erid;
}


#else	/* _KERNEL_SPT_ACRE_CYC */


#if _KERNEL_SPT_ACRE_CYC_E_NOSPT


/** %jp{nh̐(IDԍt)}%en{Create cyclic handler(ID Number Automatic Assignment)}
 * @param  pk_ccyc  %jp{nhꂽpPbgւ̃|C^}%en{Pointer to the packet containing the cyclic handler creation information}
 * @retval E_NOSPT  %jp{T|[g@\}%en{Unsupported function}
 */
ER_ID acre_cyc(const T_CCYC *pk_ccyc)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_ACRE_CYC */



/* end of file */
