/**
 *  Hyper Operating System V4 Advance
 *
 * @file  add_toq.c
 * @brief %jp{^XN^CAEgL[ɒǉ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"


#if _KERNEL_SPT_TOQ

/** %jp{^CAEg҂sɃ^XNǉ} */
void _kernel_add_toq(
		_KERNEL_T_TOQCB  *toqcb,
		_KERNEL_T_TSKHDL tskhdl,
		RELTIM           tmout)
{
	_KERNEL_T_TSKHDL tskhdl_head;
	_KERNEL_T_TSKHDL tskhdl_next;
	_KERNEL_T_TSKHDL tskhdl_prev;
	_KERNEL_T_TCB    *tcb;
	_KERNEL_T_TCB    *tcb_next;
	_KERNEL_T_TCB    *tcb_prev;
	RELTIM           tmout_next;

	/* %jp{TCB擾} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{^CAEgL[̐擪^XN擾} */
	tskhdl_head = _KERNEL_TOQ_GET_HEAD(toqcb);
	
	if ( tskhdl_head == _KERNEL_TSKHDL_NULL )
	{
		/* %jp{ŏ̂PL[ɓo^} */
		_KERNEL_TSK_SET_TOQNEXT(tcb, tskhdl);
		_KERNEL_TSK_SET_TOQPREV(tcb, tskhdl);
		_KERNEL_TOQ_SET_HEAD(toqcb, tskhdl);

		/* %jp{^CAEgݒ} */
		_KERNEL_TSK_SET_TOQDIFTIM(tcb, tmout);

		return;
	}
	
	/* %jp{}ꏊ} */
	tskhdl_next = tskhdl_head;
	tcb_next    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_next);
	tskhdl_prev = _KERNEL_TSK_GET_TOQPREV(tcb_next);
	tcb_prev    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_prev);
	do
	{
		tmout_next = _KERNEL_TSK_GET_TOQDIFTIM(tcb_next);
		
		/* %jp{Ԕr} */
		if ( tmout < tmout_next )
		{
			/* %jp{擪Ȃ} */
			if ( tskhdl_next == tskhdl_head )
			{
				_KERNEL_TOQ_SET_HEAD(toqcb, tskhdl);	/* %jp{擪|C^XV} */
			}
			
			/* %jp{Ԃ̍ݒ} */
			_KERNEL_TSK_SET_TOQDIFTIM(tcb_next, tmout_next - tmout);
			_KERNEL_TSK_SET_TOQDIFTIM(tcb, tmout);

			/* %jp{Xgɑ}} */
			_KERNEL_TSK_SET_TOQNEXT(tcb, tskhdl_next);
			_KERNEL_TSK_SET_TOQPREV(tcb, tskhdl_prev);
			_KERNEL_TSK_SET_TOQNEXT(tcb_prev, tskhdl);
			_KERNEL_TSK_SET_TOQPREV(tcb_next, tskhdl);
			
			return;
		}
		
		tmout -= tmout_next;		/* %jp{Z} */
		
		tskhdl_prev = tskhdl_next;
		tcb_prev    = tcb_next;
		tskhdl_next = _KERNEL_TSK_GET_TOQNEXT(tcb_next);		/* %jp{̃^XN֐i} */
		tcb_next    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_next);
	} while ( tskhdl_next != tskhdl_head );	/* %jp{Xg܂Ń[v} */

	/* cݒ */
	_KERNEL_TSK_SET_TOQDIFTIM(tcb, tmout);

	/* %jp{ɒǉ} */
	_KERNEL_TSK_SET_TOQNEXT(tcb, tskhdl_next);
	_KERNEL_TSK_SET_TOQPREV(tcb, tskhdl_prev);
	_KERNEL_TSK_SET_TOQNEXT(tcb_prev, tskhdl);
	_KERNEL_TSK_SET_TOQPREV(tcb_next, tskhdl);
}

#endif	/* _KERNEL_SPT_TOQ */


/* end of file */
