/**
 *  Hyper Operating System V4 Advance
 *
 * @file  add_tmq.c
 * @brief %jp{^C}L[ɃIuWFNgǉ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "core/tmq.h"



/* ^C}IuWFNgXgɒǉ */
void _kernel_add_tmq(
		_KERNEL_T_TMQCB  *tmqcb,
		_KERNEL_T_TIMOBJ *pk_timobj)
{
	/* ɓo^Ă牽Ȃ */
	if ( pk_timobj->next != NULL )
	{
		return;
	}
	
	/* ̃eBbN܂ł̎ԂZĂ */
	pk_timobj->lefttim += _KERNEL_SYS_GET_TIC();
	
	/* Xgɓo^ */
	if ( tmqcb->head == NULL )
	{
		/* Xg̏ꍇ̒ǉ */
		pk_timobj->next = pk_timobj;
		pk_timobj->prev = pk_timobj;
		tmqcb->head     = pk_timobj;
	}
	else
	{
		/* Xg̖ɒǉ */
		pk_timobj->next       = tmqcb->head;
		pk_timobj->prev       = tmqcb->head->prev;
		pk_timobj->next->prev = pk_timobj;
		pk_timobj->prev->next = pk_timobj;
	}
}



/* end of file */
