/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  rmh_que.h
 * @brief %jp{L[擪^XN̎o}%en{}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



#if _KERNEL_CFG_QUE_ALGORITHM == _KERNEL_QUE_ALG_ONEWAYLIST		/* %en{One-way list} %jp{PXg} */


/** %jp{L[̎̃^XN̎o}%en{}
 * @param	pk_que  %jp{oL[}%en{queue}
 * @return	%jp{̃^XNԂB̏ꍇ _KERNEL_TSKHDL_NULL Ԃ}
 */
_KERNEL_T_TSKHDL _kernel_nxt_que(
		_KERNEL_T_QUE    *pk_que,
		_KERNEL_T_TSKHDL tskhdl)
{
	/** %jp{ȂNULLԂ} */
	if ( tskhdl == _KERNEL_QUE_GET_TAIL(pk_que) )
	{
		return _KERNEL_TSKHDL_NULL;
	}

	/** %jp{̃^XNԂ} */
	return _KERNEL_TSK_GET_QUENEXT(_KERNEL_TSK_TSKHDL2TCB(tskhdl));
}


#elif _KERNEL_CFG_QUE_ALGORITHM == _KERNEL_QUE_ALG_TWOWAYLIST		/* %en{Two-way list} %jp{oXg} */



/** %jp{L[̎̃^XN̎o}%en{}
 * @param	pk_que  %jp{oL[}%en{queue}
 * @return	%jp{̃^XNԂB̏ꍇ _KERNEL_TSKHDL_NULL Ԃ}
 */
_KERNEL_T_TSKHDL _kernel_nxt_que(
		_KERNEL_T_QUE    *pk_que,
		_KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TSKHDL tskhdl_next;
	_KERNEL_T_TCB    *tcb;
	
	/* %jp{TCB擾} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/** %jp{̃^XN擾} */
	tskhdl_next = _KERNEL_TSK_GET_QUENEXT(tcb);

	/** %jp{ȂNULLԂ} */
	if ( tskhdl_next == _KERNEL_QUE_GET_HEAD(pk_que) )
	{
		return _KERNEL_TSKHDL_NULL;
	}

	/** %jp{̃^XNԂ} */
	return tskhdl_next;
}


#endif



/* end of file */
