/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  adp_que.c
 * @brief %en{Add the task to the queue in the order of the task's priority}%jp{^XNDxŃL[ɒǉ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



#if _KERNEL_CFG_QUE_ALGORITHM == _KERNEL_QUE_ALG_ONEWAYLIST		/* %en{One-way list} %jp{PXg} */


/** %en{Add the task to the queue in the order of the task's priority}%jp{^XNDxŃL[ɒǉ}
 * @param	que   %en{pointer of queue}%jp{ǉL[}
 * @param	ptr   %en{pointer of task}%jp{ǉ^XN}
 * @return	void
 */
void _kernel_adp_que(
		_KERNEL_T_QUE    *pk_que,
		_KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TSKHDL tskhdl_tail;
	_KERNEL_T_TSKHDL tskhdl_next;
	_KERNEL_T_TSKHDL tskhdl_prev;
	_KERNEL_T_TCB    *tcb;
	_KERNEL_T_TCB    *tcb_next;
	_KERNEL_T_TCB    *tcb_prev;
	PRI              tskpri;
	PRI              tskpri_next;

	/* %jp{TCB擾} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{^XNɏL[ݒ} */
	_KERNEL_TSK_SET_QUE(tcb, pk_que);

	/* %jp{L[̃^XN擾} */
	tskhdl_tail = _KERNEL_QUE_GET_TAIL(pk_que);

	if ( tskhdl_tail == _KERNEL_TSKHDL_NULL )		/* %en{the queue is empty}%jp{L[Ƀ^XNΐ擪ɐݒ} */
	{
		_KERNEL_TSK_SET_QUENEXT(tcb, tskhdl);
		_KERNEL_QUE_SET_TAIL(pk_que, tskhdl);
	}
	else	/* %en{que is not empty}%jp{L[łȂȂ}ʒuT} */
	{
		/* %jp{^XNDx擾} */
		tskpri = _KERNEL_TSK_GET_TSKPRI(tcb);

		/* %jp{擪T} */
		tskhdl_prev = tskhdl_tail;
		tcb_prev    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_prev);
		tskhdl_next = _KERNEL_TSK_GET_QUENEXT(tcb_prev);
		tcb_next    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_next);
		
		for ( ; ; )
		{
			/* %jp{Dxo} */
			tskpri_next = _KERNEL_TSK_GET_TSKPRI(tcb_next);
			
			if ( tskpri_next > tskpri )
			{
				break;
			}
			
			/* %jp{T} */
			tskhdl_prev = tskhdl_next;
			tcb_prev    = tcb_next;
			tskhdl_next = _KERNEL_TSK_GET_QUENEXT(tcb_next);
			tcb_next    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_next);
			
			/* %jp{Ȃ甲} */
			if ( tskhdl_prev == tskhdl_tail )
			{
				_KERNEL_QUE_SET_TAIL(pk_que, tskhdl);
				break;
			}
		}
		
		/* %jp{}} */
		_KERNEL_TSK_SET_QUENEXT(tcb_prev, tskhdl);
		_KERNEL_TSK_SET_QUENEXT(tcb, tskhdl_next);
	}
}


#elif _KERNEL_CFG_QUE_ALGORITHM == _KERNEL_QUE_ALG_TWOWAYLIST		/* %en{Two-way list} %jp{oXg} */


/** %en{Add the task to the queue in the order of the task's priority}%jp{^XNDxŃL[ɒǉ}
 * @param	que   %en{pointer of queue}%jp{ǉL[}
 * @param	ptr   %en{pointer of task}%jp{ǉ^XN}
 * @return	void
 */
void _kernel_adp_que(
		_KERNEL_T_QUE    *pk_que,
		_KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TSKHDL tskhdl_head;
	_KERNEL_T_TSKHDL tskhdl_next;
	_KERNEL_T_TSKHDL tskhdl_prev;
	_KERNEL_T_TCB    *tcb;
	_KERNEL_T_TCB    *tcb_next;
	_KERNEL_T_TCB    *tcb_prev;
	PRI              tskpri;
	PRI              tskpri_next;


	/* %jp{TCB擾} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{^XNɏL[ݒ} */
	_KERNEL_TSK_SET_QUE(tcb, pk_que);

	/* %jp{L[̃^XN擾} */
	tskhdl_head = _KERNEL_QUE_GET_HEAD(pk_que);
	
	if ( tskhdl_head == _KERNEL_TSKHDL_NULL )		/* %en{the queue is empty}%jp{L[Ƀ^XNΐ擪ɐݒ} */
	{
		_KERNEL_TSK_SET_QUENEXT(tcb, tskhdl);
		_KERNEL_TSK_SET_QUEPREV(tcb, tskhdl);
		_KERNEL_QUE_SET_HEAD(pk_que, tskhdl);
	}
	else	/* %en{que is not empty}%jp{L[łȂȂ}ʒuT} */
	{
		/* %jp{^XNDx擾} */
		tskpri = _KERNEL_TSK_GET_TSKPRI(tcb);
		
		/* %jp{擪T} */
		tskhdl_next = tskhdl_head;
		tcb_next    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_next);
		
		do
		{
			/* %jp{Dxo} */
			tskpri_next = _KERNEL_TSK_GET_TSKPRI(tcb_next);
			
			if ( tskpri_next > tskpri )
			{
				if ( tskhdl_next == tskhdl_head )	/* %jp{}ʒu擪ꍇ} */
				{
					tskhdl_prev = _KERNEL_TSK_GET_QUEPREV(tcb_next);
					tcb_prev    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_prev);
					_KERNEL_QUE_SET_HEAD(pk_que, tskhdl);
				}
				break;
			}
			
			/* %jp{T} */
			tskhdl_prev = tskhdl_next;
			tcb_prev    = tcb_next;
			tskhdl_next = _KERNEL_TSK_GET_QUENEXT(tcb_next);
			tcb_next    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_next);
		} while ( tskhdl_next != tskhdl_head );
		
		/* %jp{}} */
		_KERNEL_TSK_SET_QUENEXT(tcb, tskhdl_next);
		_KERNEL_TSK_SET_QUEPREV(tcb, tskhdl_prev);
		_KERNEL_TSK_SET_QUENEXT(tcb_prev, tskhdl);
		_KERNEL_TSK_SET_QUEPREV(tcb_next, tskhdl);
	}
}


#endif



/* end of file */
