/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  dsp_wup.c
 * @brief %jp{^XNN}%en{Wakeup Task}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"


/** %jp{^XNN}%en{Wakeup Task}
 * @param  tskhdl   %jp{NΏۂ̃^XNnh}%en{Handle of the task to be woken up}
 * @retval void
 */
void _kernel_dsp_wup_tsk(_KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TCB_PTR     tcb;
	_KERNEL_TSK_T_TSKSTAT tskstat;
	
	/* %jp{TCB擾}%en{get TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{݂̏Ԃ擾}%en{get current state} */
	tskstat = _KERNEL_TSK_GET_TSKSTAT(tcb);
	
#if _KERNEL_SPT_SUS_TSK	&& (_KERNEL_TMAX_SUSCNT > 0)	/* %jp{TXyh̃f̏ꍇ}%en{Supported suspend mode} */
	if ( !(tskstat & _KERNEL_TTS_SUS) )
	{
		/* %jp{fB[L[ɐڑ}%en{add to ready-queue} */
		_KERNEL_SYS_ADD_RDQ(tskhdl);
		tskstat = _KERNEL_TTS_RDY;
	}
	else
	{
		tskstat = _KERNEL_TTS_SUS;
	}
#else
	/* %jp{fB[L[ɐڑ}%en{add to ready-queue} */
	_KERNEL_ADD_RDQ(tskhdl);
	tskstat = _KERNEL_TTS_RDY;
#endif
	
	/* %jp{҂Ԃ}%en{set new state} */
	_KERNEL_TSK_SET_TSKSTAT(tcb, tskstat);
}



/* end of file */
