/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  vsig_int.c
 * @brief %jp{ReLXg}%en{context control}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"



/* %jp{ݗp} */
void vsig_int(int inhno)
{
	/* %jp{ݗpZ}tH} */
	WaitForSingleObject(_kernel_ictxcb.hSemIntLock, INFINITE);
	
	/* %jp{NeBJZNVɓ} */
	EnterCriticalSection(&_kernel_ictxcb.CriticalSection);

	/* %jp{ݏԂɐݒ} */
	_kernel_ictxcb.inhno = inhno;

	/* %jp{ݎs̃ReLXg݃[hɈڍs} */
	SuspendThread(_kernel_ictxcb.runctxcb->hThread);
	_kernel_ictxcb.runctxcb->blInterrupt = TRUE;
	SetEvent(_kernel_ictxcb.runctxcb->hIntEvent);
	
	/* %jp{NeBJZNVo} */
	LeaveCriticalSection(&_kernel_ictxcb.CriticalSection);
}



/* end of file */
