/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  ksta_ctx.c
 * @brief %jp{ReLXg}%en{context control}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"


/** %jp{ReLXg̊Jn} */
void _kernel_sta_ctx(_KERNEL_T_CTXCB *ctxcb)
{
	/* %jp{sReLXg̓o^} */
	_kernel_ictxcb.runctxcb = ctxcb;

	/* %jp{Xbh̎sJn} */
	SetEvent(ctxcb->hEvent);
	
	if ( GetCurrentThreadId() == _kernel_ictxcb.dwPrimaryThreadId )
	{
		/* %jp{_CAO\} */
		MessageBox(NULL, _T("Press OK, Exit a process"), _T("Hyper Operationg System V4 Advance for Win32"), MB_OK);
		
		/* %jp{I} */
		ExitProcess(0);
	}
}


/* end of file */
