/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  kcre_ctx.c
 * @brief %jp{ReLXg}%en{context control}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <process.h>
#include "core/core.h"
#include "object/inhobj.h"


static unsigned __stdcall	_kernel_ctx_ent(void *param);		/**< %jp{ReLXg̃XbhGg[֐} */
static unsigned __stdcall	_kernel_ctx_int(void *param);		/**< %jp{ReLXg̊ݏXbh} */


/** %jp{sReLXg̍쐬} */
void _kernel_cre_ctx(
		_KERNEL_T_CTXCB	*ctxcb,		/* ReLXg쐬AhX */
		FP              entry,			/* ReLXg̎sJnԒn */
		VP_INT          exinf1,			/* ReLXg̎sp[^1 */
		VP_INT          exinf2)			/* ReLXg̎sp[^2 */
{
	ctxcb->blInterrupt = FALSE;

	/* %jp{Ni[} */
	ctxcb->entry  = entry;
	ctxcb->exinf1 = exinf1;
	ctxcb->exinf2 = exinf2;
	
	/* %jp{ReLXgXbh} */
	ctxcb->hEvent     = CreateEvent(NULL, FALSE, FALSE, NULL);
	ctxcb->hIntEvent  = CreateEvent(NULL, FALSE, FALSE, NULL);

#if defined(_MSC_VER)	/* Visual-C++ ̏ꍇ */
	ctxcb->hThread    = (HANDLE)_beginthreadex(NULL, 0, _kernel_ctx_ent, (void *)ctxcb, 0, &ctxcb->dwThreadId);
	ctxcb->hIntThread = (HANDLE)_beginthreadex(NULL, 0, _kernel_ctx_int, (void *)ctxcb, 0, &ctxcb->dwIntThreadId);
#else					/* Visual-C++ ȊO */
	ctxcb->hThread    = CreateThread(NULL, 0, _kernel_ctx_ent, (LPVOID)ctxcb, 0, &ctxcb->dwThreadId);
	ctxcb->hIntThread = CreateThread(NULL, 0, _kernel_ctx_int, (LPVOID)ctxcb, 0, &ctxcb->dwIntThreadId);
#endif
}


/** %jp{ReLXg̃XbhGg[֐} */
unsigned __stdcall _kernel_ctx_ent(void *param)
{
	_KERNEL_T_CTXCB *ctxcb;

	/* %jp{ReLXg擾} */
	ctxcb = (_KERNEL_T_CTXCB *)param;

	/* %jp{Jn҂} */
	WaitForSingleObject(ctxcb->hEvent, INFINITE);

	/* %jp{X^[gpsetjmp} */
	setjmp(ctxcb->jmpenv);

	/* Jn */
	ctxcb->entry(ctxcb->exinf1, ctxcb->exinf2);
	
	return 0;
}


/** %jp{݃nh} */
unsigned __stdcall _kernel_ctx_int(void *param)
{
	_KERNEL_T_CTXCB *ctxcb;

	/* %jp{ReLXg擾} */
	ctxcb = (_KERNEL_T_CTXCB *)param;
	
	for ( ; ; )
	{
		/* %jp{Jn҂} */
		WaitForSingleObject(ctxcb->hIntEvent, INFINITE);

		_kernel_ictxcb.blDisInt = TRUE;

		/* %jp{ݏ} */
		_kernel_sta_inh();
		_kernel_ictxcb.blIntCtx = TRUE;
		_kernel_exe_inh(_kernel_ictxcb.inhno);
		_kernel_ictxcb.blIntCtx = FALSE;
		_kernel_end_inh();
		
		/* ReLXgA */
		ctxcb->blInterrupt      = FALSE;
		_kernel_ictxcb.blDisInt = FALSE;
		ResumeThread(ctxcb->hThread);							/* %jp{XbhA} */
		ReleaseSemaphore(_kernel_ictxcb.hSemIntLock, 1, NULL);	/* %jp{݃bN} */
	}
	
	return 0;
}



/* end of file */
