/** 
 *  Hyper Operating System V4 Advance
 *
 * Copyright (C) 1998-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "arm_v4t.inc"


				.code	32
				.text
				.align	2

				.global	_kernel_ictxcb
				.global	_kernel_sta_inh
				.global	_kernel_end_inh
				.global	_kernel_exe_inh


/************************************************
  FIQ handler
 ************************************************/
				.global	_kernel_fiq_hdr
_kernel_fiq_hdr:
			/* ---- WX^ޔ */
				mrs		r13, cpsr								/* cpsrr13ɑޔ */
				msr		cpsr_c, #(Mode_SYS | F_Bit | I_Bit)		/* SYS[hɈڍs */
				stmfd	sp!, {r0-r3, r12, lr}					/* SYS[h̔ėpWX^ޔ */
				msr		cpsr_c, #(Mode_FIQ | F_Bit | I_Bit)		/* IRQ[hɈڍs */
				mov		r0, lr									/* lr_irq o */
				mrs		r1, spsr								/* spsr_irq o */
				mov		r2, r13									/* cpsro */
				msr		cpsr_c, #(Mode_SYS | F_Bit | I_Bit)		/* SYS[hɈڍs */
				stmfd	sp!, {r0, r1}							/* lr_fiq, spsr_fiqޔ */
				
			/* ---- ݃}XNݒ */
				ldr		r0, =_kernel_ictxcb
				ldr		r3, [r0, #ICTXCB_IMSK]					/* Âimsklo */
				and		r2, r2, #(F_Bit | I_Bit)
				strb	r2, [r0, #ICTXCB_IMSK]					/* cpsrlimsklɐݒ */
				
			/* ---- dݔ */
				ldrb	r1, [r0, #ICTXCB_INTCNT]				/* 荞݃lXgJE^l擾 */
				add		r1, r1, #1								/* 荞݃lXgJE^CNg */
				strb	r1, [r0, #ICTXCB_INTCNT]				/* 荞݃lXgJE^ݒ */
				cmp		r1, #1
				bne		multiple_int							/* d荞݂Ȃ番 */
				
			/* ---- SP݃ReLXĝ̂ɐؑւ */
				mov		r1, sp									/* ^XNSPۑ */
				ldr		sp, [r0, #ICTXCB_ISP]					/* 荞ݗpX^bNɐ؂ւ */
				stmfd	sp!, {r1, r3}							/* ^XNSPƋimaskۑ */
				
			/* ---- ݊Jn */
				bl		_kernel_sta_inh							/* 荞݊Jn */
				
			/* ---- ݃nhs */
				mov		r0, #INHNO_FIQ
				bl		_kernel_exe_inh
				
			/* ---- ݏ̏Iݒ */
				ldmfd	sp!, {r1, r3}							/* ėpWX^A */
				mov		sp, r1									/* SP̃ReLXĝ̂ɖ߂ */
				ldr		r0, =_kernel_ictxcb						/* 荞݃lXgJE^̃AhX擾 */
				mov		r1, #0									/* 荞݃lXgJE^0ɖ߂ */
				strb	r1, [r0, #ICTXCB_INTCNT]				/* 荞݃lXgJE^lݒ */
			
			/* ---- ݃}XNlA */
				ldr		r1, [sp, #4]							/* spsr_fiq lo */
				and		r1, r1, #(F_Bit | I_Bit)
				cmp		r1, r3									/* imsklƔr */
				bne		return_int								/* svȂIXLbv */
				strb	r3, [r0, #ICTXCB_IMSK]					/* }XNlA */
				
			/* ---- ݏI */
				bl		_kernel_end_inh							/* 荞ݏI */

				ldr		r0, =_kernel_ictxcb
				ldr		r1, [sp, #4]							/* spsr_irq lo */
				ldrb	r0, [r0, #ICTXCB_IMSK]					/* ̎_łimsklo */
				bic		r1, r1, #(F_Bit | I_Bit)
				and		r0, r0, #(F_Bit | I_Bit)
				orr		r1, r1, r0
				str		r1, [sp, #4]							/* spsr_irq imsklf */

return_int:
			/* ---- A */
				ldmfd	sp!, {r0, r1}							/* lr_fiq, spsr_fiq A */
				msr		cpsr_c, #(Mode_FIQ | F_Bit | I_Bit)		/* FIQ[hɈڍs */
				mov		lr, r0									/* lr_irq A */
				msr		spsr_csxf, r1 							/* spsr_fiq A */
				msr		cpsr_c, #(Mode_SYS | F_Bit | I_Bit)		/* SYS[hɈڍs */
				ldmfd	sp!, {r0-r3, r12, lr}					/* SYS[h̔ėpWX^A */
				msr		cpsr_c, #(Mode_FIQ | F_Bit | I_Bit)		/* FIQ[hɈڍs */
				subs	pc, lr, #4								/* ݕA */


			/* ---- d荞ݏ */
multiple_int:
			/* ---- X^bN8oCgACgɈړ */
				mov		r1,  sp									/* 荞ݔSYS[hSP8̔{̕ۏ؂Ȃ̂ */
				bic		sp, sp, #0x7
				stmfd	sp!, {r0, r1}							/* ^XNSP荞ݗpX^bNɕۑ(8̔{ɂȂ悤r1) */
				
			/* ---- 荞݃nhs */
				mov		r0, #INHNO_IRQ
				bl		_kernel_exe_inh

			/* ---- X^bNACgA */
				ldmfd	sp!, {r0, r1}							/* ėpWX^A */
				mov		sp, r1
				
			/* ---- 荞݃JE^A */
				ldrb	r1, [r0, #ICTXCB_INTCNT]
				add		r1, r1, #1
				strb	r1, [r0, #ICTXCB_INTCNT]
				b		return_int								/* A */


				.end


/* end of file */
