; --------------------------------------------------------------------------- 
;  Hyper Operating System V4 Advance
;   %jp{FIQnh(ARM V4T A[LeN`p)}%en{FIQ handler for ARM V4T}
;
;  Copyright (C) 1998-2006 by Project HOS
;  http://sourceforge.jp/projects/hos/
; --------------------------------------------------------------------------- 


				INCLUDE	arm_v4t.inc


				IMPORT	_kernel_ictxcb
				IMPORT	_kernel_sta_inh
				IMPORT	_kernel_end_inh
				IMPORT	_kernel_exe_inh
				EXPORT	_kernel_fiq_hdr						; FIQnh


				PRESERVE8
				AREA	code, CODE, READONLY
				CODE32

; ----------------------------------------------
;  FIQ nh
; ----------------------------------------------
_kernel_fiq_hdr
			; ---- WX^ޔ
				msr		cpsr_c, #Mode_SYS:OR:F_Bit:OR:I_Bit		; SYS[hɈڍs
				stmfd	sp!, {r0-r3, r12, lr}					; SYS[h̔ėpWX^ޔ
				msr		cpsr_c, #Mode_FIQ:OR:F_Bit:OR:I_Bit		; FIQ[hɈڍs
				mov		r0, lr									; lr_fiq o
				mrs		r1, spsr								; spsr_fiq o
				msr		cpsr_c, #Mode_SYS:OR:F_Bit:OR:I_Bit		; SYS[hɈڍs
				stmfd	sp!, {r0, r1}							; lr_fiq, spsr_fiqޔ
				
			; ---- ݃}XNݒ
				ldr		r0, =_kernel_ictxcb
				ldr		r3, [r0, #ICTXCB_IMSK]					; Âimsklo
				mov		r1, #F_Bit:OR:I_Bit
				strb	r1, [r0, #ICTXCB_IMSK]					; imsklݒ
				
			; ---- dݔ
				ldrb	r1, [r0, #ICTXCB_INTCNT]				; 荞݃lXgJE^l擾
				add		r1, r1, #1								; 荞݃lXgJE^CNg
				strb	r1, [r0, #ICTXCB_INTCNT]				; 荞݃lXgJE^ݒ
				cmp		r1, #1
				bne		multiple_int							; d荞݂Ȃ番
				
			; ---- SP݃ReLXĝ̂ɐؑւ
				mov		r1, sp									; ^XNSPۑ
				ldr		sp, [r0, #ICTXCB_ISP]					; 荞ݗpX^bNɐ؂ւ
				stmfd	sp!, {r1, r3}							; ^XNSPƋimaskۑ
				
			; ---- ݊Jn
				bl		_kernel_sta_inh							; 荞݊Jn
				
			; ---- ݃nhs
				mov		r0, #INHNO_IRQ
				bl		_kernel_exe_inh
				
			; ---- ݏ̏Iݒ
				ldmfd	sp!, {r1, r3}							; ėpWX^A
				mov		sp, r1									; SP̃ReLXĝ̂ɖ߂
				ldr		r0, =_kernel_ictxcb						; 荞݃lXgJE^̃AhX擾
				mov		r1, #0									; 荞݃lXgJE^0ɖ߂
				strb	r1, [r0, #ICTXCB_INTCNT]				; 荞݃lXgJE^lݒ
			
			; ---- ݃}XNlA
				ldr		r1, [sp, #4]							; spsr_fiq lo
				and		r1, r1, #Mode_MASK
				cmp		r1, #Mode_IRQ							; IRQOFIQPA
				beq		return_int								; 
				strb	r3, [r0, #ICTXCB_IMSK]					; }XNlA
				
			; ---- ݏI
				bl		_kernel_end_inh							; 荞ݏI

			; ---- A抄݃}XNݒ
				ldr		r0, =_kernel_ictxcb
				ldr		r1, [sp, #4]							; spsr_irq lo
				tst		r1, #F_Bit								; ւƓFIQꍇ̂ŃPA
				ldrbeq	r0, [r0, #ICTXCB_IMSK]					; ̎_łimsklo
				biceq	r1, r1, #F_Bit:OR:I_Bit
				orreq	r1, r1, r0
				streq	r1, [sp, #4]							; spsr_irq imsklf

return_int
			; ---- A
				ldmfd	sp!, {r0, r1}							; lr_fiq, spsr_fiq A
				msr		cpsr_c, #Mode_FIQ:OR:F_Bit:OR:I_Bit		; FIQ[hɈڍs
				mov		lr, r0									; lr_irq A
				msr		spsr_csxf, r1 							; spsr_fiq A
				msr		cpsr_c, #Mode_SYS:OR:F_Bit:OR:I_Bit		; SYS[hɈڍs
				ldmfd	sp!, {r0-r3, r12, lr}					; SYS[h̔ėpWX^A
				msr		cpsr_c, #Mode_FIQ:OR:F_Bit:OR:I_Bit		; FIQ[hɈڍs
				subs	pc, lr, #4								; ݕA


			; ---- d荞ݏ
multiple_int
			; ---- X^bN8oCgACgɈړ
				mov		r1,  sp									; 荞ݔSYS[hSP8̔{̕ۏ؂Ȃ̂
				bic		sp, sp, #0x7
				stmfd	sp!, {r0, r1}							; ^XNSP荞ݗpX^bNɕۑ(8̔{ɂȂ悤r1)
				
			; ---- 荞݃nhs
				mov		r0, #INHNO_IRQ
				bl		_kernel_exe_inh

			; ---- X^bNACgA
				ldmfd	sp!, {r0, r1}							; ėpWX^A
				mov		sp, r1
				
			; ---- 荞݃JE^A
				ldrb	r1, [r0, #ICTXCB_INTCNT]
				add		r1, r1, #1
				strb	r1, [r0, #ICTXCB_INTCNT]
				b		return_int								; A


				END


;  end of file
