/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  kexe_irc.c
 * @brief %jp{PC/AT݊@}%en{PC/AT}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/inhobj.h"
#include "object/isrobj.h"


/** %jp{݃Rg[̊ݏ} */
void _kernel_exe_irc(INHNO inhno)
{
	INTNO intno;
	
	intno = (inhno - _KERNEL_IRC_PIC1_VECT);
	
	/* %jp{݃T[rX[`Ăяo} */
	_kernel_exe_isr(intno);
	
	/* EOI */
	if ( intno < 8 )
	{
		_kernel_outpb(_KERNEL_IRC_PIC1_OCW2, (intno | 0x60));
	}
	else
	{
		_kernel_outpb(_KERNEL_IRC_PIC2_OCW2, ((intno - 8) | 0x60));
		_kernel_outpb(_KERNEL_IRC_PIC1_OCW2, 0x62);
	}
}


/* end of file */
