/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  kernel.h
 * @brief %jp{J[lwb_t@C}%en{uITRON4.0 kernel header file}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__kernel_h__
#define _KERNEL__kernel_h__


#include "itron.h"


/** %jp{o[W} */
#define TKERNEL_MAKER				0x0008					/**< %jp{[J[R[h(l)} */
#define TKERNEL_PRID				0x0000					/**< %jp{J[l̎ʔԍ()} */
#define TKERNEL_SPVER				0x5402					/**< %jp{ITRONdl̃o[W(ITRON Ver 4.02)} */
#define TKERNEL_PRVER				0x0000					/**< %jp{J[l̃o[Wԍ(HOS-V4a Ver 0.00)} */


#define TMAX_ACTCNT					_KERNEL_TMAX_ACTCNT		/**< %jp{^XN̋NvL[CO̍ől} */
#define TMAX_WUPCNT					_KERNEL_TMAX_WUPCNT		/**< %jp{^XN̋NvL[CO̍ől} */
#define TMAX_SUSCNT					_KERNEL_TMAX_SUSCNT		/**< %jp{^XN̋҂lXg̍ől} */

#define TMAX_MAXSEM					_KERNEL_TMAX_MAXSEM		/**< %jp{Z}tH̍ől} */


#define _KERNEL_TSZ_ALIGNED(size)	(((size) + _KERNEL_MEM_ALIGN - 1) & ~(_KERNEL_MEM_ALIGN - 1))

/** %jp{f[^L[̗̈̃TCY} */
#define TSZ_DTQ(dtqcnt)				((SIZE)(dtqcnt) * (SIZE)sizeof(VP_INT))

/** %jp{bZ[WL[wb_̈̃TCY} */
#define TSZ_MPRIHD(maxmpri)			((SIZE)(maxmpri) * (SIZE)sizeof(T_MSG_PRI *))

/** %jp{v[̈̃TCY} */
#define TSZ_MPF(blkcnt, blksz)		((SIZE)(blkcnt) * (SIZE)_KERNEL_TSZ_ALIGNED(blksz))

#define TSZ_MBF(msgcnt, msgsz)		((SIZE)(msgcnt) * (SIZE)((msgsz) + sizeof(UINT)))

#define TSZ_MPL(blkcnt, blksz)		((SIZE)(blkcnt) * ((SIZE)_KERNEL_TSZ_ALIGNED(blksz) + (SZIE)))



/** %jp{o[W} */
typedef struct t_rver
{
	UH      maker;			/**< %jp{J[l̃[J[R[h} */
	UH      prid;			/**< %jp{J[l̎ʔԍ} */
	UH      spver;			/**< %jp{ITRONdl̃o[W} */
	UH      prver;			/**< %jp{J[l̃o[Wԍ} */
	UH      prno[4];		/**< %jp{J[li̊Ǘ} */
} T_RVER;


/** %jp{^XN} */
typedef struct t_ctsk
{
	ATR     tskatr;			/**< %jp{^XN} */
	VP_INT  exinf;			/**< %jp{^XN̊g} */
	FP      task;			/**< %jp{^XN̋NԒn} */
	PRI     itskpri;		/**< %jp{^XN̋NDx} */
	SIZE    stksz;			/**< %jp{X^bN̈̃TCY(oCg)} */
	VP      stk;			/**< %jp{X^bN̈̐擪Ԓn} */
} T_CTSK;

/** %jp{^XN} */
typedef struct t_rtsk
{
	STAT    tskstat;		/**< %jp{^XN} */
	PRI     tskpri;			/**< %jp{^XŇݗDx} */
	PRI	    tskbpri;		/**< %jp{^XÑx[XDx} */
	STAT    tskwait;		/**< %jp{҂v} */
	ID      wobjid;			/**< %jp{҂Ώۂ̃IuWFNgIDԍ} */
	TMO     lefttmo;		/**< %jp{^CAEg܂ł̎} */
	UINT    actcnt;			/**< %jp{NvL[CO} */
	UINT    wupcnt;			/**< %jp{NvL[CO} */
	UINT    suscnt;			/**< %jp{҂vlXg} */
	
	/* %jp{ȉAƎ}%en{HOS extention} */
#if _KERNEL_SPT_RTSK_TSKATR
	ATR     tskatr;			/**< %jp{^XN(HOSƎg)} */
#endif
#if _KERNEL_SPT_RTSK_EXINF
	VP_INT  exinf;			/**< %jp{^XN̊g(HOSƎg)} */
#endif
#if _KERNEL_SPT_RTSK_TASK
	FP      task;			/**< %jp{^XN̋NԒn(HOSƎg)} */
#endif
#if _KERNEL_SPT_RTSK_ITSKPRI
	PRI     itskpri;		/**< %jp{^XN̋NDx(HOSƎg)} */
#endif
#if _KERNEL_SPT_RTSK_STKSZ
	SIZE    stksz;			/**< %jp{X^bN̈̃TCY(oCg)(HOSƎg)} */
#endif
#if _KERNEL_SPT_RTSK_STK
	VP      stk;			/**< %jp{X^bN̈̐擪Ԓn(HOSƎg)} */
#endif
} T_RTSK;

/* ^XN(ȈՔ) */
typedef struct t_rtst
{
	STAT    tskstat;		/**< %jp{^XN} */
	STAT    tskwait;		/**< %jp{҂v} */
	
	/* %jp{ȉAƎ}%en{HOS extention} */
#if _KERNEL_SPT_RTST_TSKATR
	ATR     tskatr;			/**< %jp{^XN(HOSƎg)} */
#endif
#if _KERNEL_SPT_RTST_EXINF
	VP_INT  exinf;			/**< %jp{^XN̊g(HOSƎg)} */
#endif
#if _KERNEL_SPT_RTST_TASK
	FP      task;			/**< %jp{^XN̋NԒn(HOSƎg)} */
#endif
#if _KERNEL_SPT_RTST_ITSKPRI
	PRI     itskpri;		/**< %jp{^XN̋NDx(HOSƎg)} */
#endif
#if _KERNEL_SPT_RTST_STKSZ
	SIZE    stksz;			/**< %jp{X^bN̈̃TCY(oCg)(HOSƎg)} */
#endif
#if _KERNEL_SPT_RTST_STK
	VP      stk;			/**< %jp{X^bN̈̐擪Ԓn(HOSƎg)} */
#endif
} T_RTST;


/** %jp{^XNO[``}%en{Task exception handling routine definition information} */
typedef struct t_dtex
{
	ATR		texatr;			/**< %jp{^XNO[`}%en{Task exception handling routine attribute} */
	FP		texrtn;			/**< %jp{^XNO[`̋NԒn}%en{Task exception handling routine start address} */
} T_DTEX;


/** %jp{Z}tH}%en{Semaphore creation information packet} */
typedef struct t_csem
{
	ATR		sematr;			/**< %jp{Z}tH}%en{Semaphoer attribute} */
	UINT	isemcnt;		/**< %jp{Z}tH̏l}%en{Initial semaphoer resource count} */
	UINT	maxsem;			/**< %jp{Z}tH̍ő厑}%en{Maximum semaphoer resource count} */
} T_CSEM;

/** %jp{Z}tHԏ}%en{Semaphore state packet} */
typedef struct t_rsem
{
	ID		wtskid;			/**< %jp{Z}tH̑҂s̐擪̃^XNIDԍ}%en{ID number of the task at the head of the semaphore's wait queue} */
	UINT	semcnt;			/**< %jp{Z}tȞ݂̎}%en{Current semaphore resource count} */
} T_RSEM;


/** %jp{CxgtO}%en{Eventflag creation information packet} */
typedef struct t_cflg
{
	ATR		flgatr;			/**< %jp{CxgtO}%en{Eventflag attribute} */
	FLGPTN	iflgptn;		/**< %jp{CxgtÕrbgp^[̏l}%en{Initial value of eventflag bit pattern} */
} T_CFLG;

/** %jp{CxgtO}%en{Eventflag state packet} */
typedef struct t_rflg
{
	ID		wtskid;			/**< %jp{CxgtȎ҂s̐擪̃^XNIDԍ}%en{ID number of the task at the head of the eventflag's wait queue} */
	FLGPTN	flgptn;			/**< %jp{CxgtǑ݂̃rbgp^[}%en{Eventflag's vurrent bit pattern} */
} T_RFLG;


/** %jp{f[^L[}%en{Data queue creation information packet} */
typedef struct t_cdtq
{
	ATR  dtqatr;			/**< %jp{f[^L[}%en{Data queue attribute} */
	UINT dtqcnt;			/**< %jp{f[^L[̗̈e(f[^̌)}%en{Capacity of the data queue area(the number of data elements)} */
	VP   dtq;				/**< %jp{f[^L[̈̐擪Ԓn}%en{Start address of the data queue area} */
} T_CDTQ;

/** %jp{f[^L[}%en{Data queue state packet} */
typedef struct t_rdtq
{
	ID		stskid;			/**< %jp{f[^L[̑M҂s̐擪̃^XNIDԍ}%en{ID number of the task at the head of the send-wait queue} */
	ID		rtskid;			/**< %jp{f[^L[̎M҂s̐擪̃^XNIDԍ}%en{ID number of the task at the head of the receive-wait queue} */
	UINT	sdtqcnt;		/**< %jp{f[^L[ɓĂf[^̐}%en{The number of data elemnts int the data queue} */
} T_RDTQ;


/** %jp{[{bNX} */
typedef struct t_cmbx
{
	ATR		mbxatr;			/**< %jp{[{bNX} */
	PRI		maxmpri;		/**< %jp{M郁bZ[W̗Dx̍ől} */
	VP		mprihd;			/**< %jp{Dxʂ̃bZ[WL[wb_̈̐擪Ԓn} */
} T_CMBX;

/** %jp{[{bNX} */
typedef struct t_rmbx
{
	ID		wtskid;			/**< %jp{[{bNX̑҂s̐擪̃^XNIDԍ} */
	T_MSG	*pk_msg;		/**< %jp{bZ[WL[̐擪̃bZ[WpPbg̐擪Ԓn} */
} T_RMBX;



/** %jp{~[ebNX} */
typedef struct t_cmtx
{
	ATR		mtxatr;			/* ~[ebNX */
	PRI		ceilpri;		/* ~[ebNX̏Dx */
} T_CMTX;


/* bZ[Wobt@ԏ */
typedef struct t_rmbf
{
	ID		stskid;			/* bZ[Wobt@̑M҂s̐擪̃^XNIDԍ */
	ID		rtskid;			/* bZ[Wobt@̎M҂s̐擪̃^XNIDԍ */
	UINT	smsgcnt;		/* bZ[Wobt@ɓĂ郁bZ[W̐ */
	SIZE	fmbfsz;			/* bZ[Wobt@̈̋󂫗̈̃TCY(oCgAŒ̊Ǘ̈) */
} T_RMBF;


/** %jp{Œ蒷v[} */
typedef struct t_cmpf
{
	ATR		mpfatr;			/**< %jp{Œ蒷v[} */
	UINT	blkcnt;			/**< %jp{lł郁ubN()} */
	UINT	blksz;			/**< %jp{ubÑTCY(oCg)} */
	VP		mpf;			/**< %jp{Œ蒷v[̈̐擪Ԓn} */
} T_CMPF;


/** %jp{Œ蒷v[} */
typedef struct t_rmpf
{
	ID		wtskid;			/**< %jp{Œ蒷v[̑҂s̐擪̃^XNIDԍ} */
	UINT	fblkcnt;		/**< %jp{Œ蒷v[̋󂫃ubN()} */
} T_RMPF;


/** %jp{nh} */
typedef struct t_ccyc
{
	ATR		cycatr;			/**< %jp{nh} */
	VP_INT	exinf;			/**< %jp{nh̊g} */
	FP		cychdr;			/**< %jp{nh̋NԒn} */
	RELTIM	cyctim;			/**< %jp{nh̋N} */
	RELTIM	cycphs;			/**< %jp{nh̋Nʑ} */
} T_CCYC;


/** %jp{nh} */
typedef struct t_rcyc
{
	STAT	cycatr;			/**< %jp{nh̓} */
	RELTIM	lefttim;		/**< %jp{nhɋN܂ł̎} */
} T_RCYC;


/* ݃nh̒`p */
typedef struct t_dinh
{
	ATR		inhatr;			/* ݃nh */
	FP		inthdr;			/* ݃nh̋NԒn */
} T_DINH;


/* ݃T[rX[` */
typedef struct t_cisr
{
	ATR    isratr;			/* ݃T[rX[` */
	VP_INT exinf;			/* ݃T[rX[`̊g */
	INTNO  intno;			/* ݃T[rX[`t銄ݔԍ */
	FP     isr;				/* ݃T[rX[`̋NԒn */
} T_CISR;



#ifdef __cplusplus
extern "C" {
#endif

/* %jp{OS̋N}%en{Kernel Management Functions} */
ER      vsta_knl(void);										/**< %jp{J[l̊Jn(ƎT[rXR[)}%en{Start Kernel(HOS original)} */

/* %jp{^XNǗ@\}%en{Task Management Functions} */
ER      cre_tsk(ID tskid, const T_CTSK *pk_ctsk);			/**< %jp{^XN̐}%en{Create Task} */
ER_ID   acre_tsk(const T_CTSK *pk_ctsk);					/**< %jp{^XN̐(IDԍt)}%en{Create Task(ID Number Automatic Assignment)} */
ER      del_tsk(ID tskid);									/**< %jp{^XN̍폜}%en{Delete Task} */
ER      act_tsk(ID tskid);									/* %jp{^XN̋N}%en{Activate Task} */
ER      iact_tsk(ID tskid);									/* ^XN̋N(^XNReLXgp) */
ER_UINT can_act(ID tskid);									/* ^XNNṽLZ */
ER      sta_tsk(ID tskid, VP_INT stacd);					/* ^XN̋N(NR[hw) */
void    ext_tsk(void);										/* ^XN̏I */
void    exd_tsk(void);										/* ^XN̏Iƍ폜 */
ER      ter_tsk(ID tskid);									/* ^XN̋I */
ER      chg_pri(ID tskid, PRI tskpri);						/* ^XNDx̕ύX */
ER      get_pri(ID tskid, PRI *p_tskpri);					/* ^XNDx̎Q */
ER      ref_tsk(ID tskid, T_RTSK *p_rtsk);					/* ^XN̏ԎQ */
ER      ref_tst(ID tskid, T_RTST *p_rtst);					/* ^XN̏ԎQ(ȈՔ) */

/* ^XNt@\ */
ER      slp_tsk(void);										/* ^XN̋N҂ */
ER      tslp_tsk(TMO tmout);								/* ^XN̋N҂(^CAEg) */
ER      wup_tsk(ID tskid);									/* ^XN̋N */
ER      iwup_tsk(ID tskid);									/* ^XN̋N(^XNReLXgp) */
ER_UINT can_wup(ID tskid);									/* ^XNNṽLZ */
ER      rel_wai(ID tskid);									/* ҂Ԃ̋ */
ER      irel_wai(ID tskid);									/* ҂Ԃ̋(^XNReLXgp) */
ER      sus_tsk(ID tskid);									/* ҂Ԃւ̈ڍs */
ER      rsm_tsk(ID tskid);									/* ҂Ԃ̍ĊJ */
ER      frsm_tsk(ID tskid);									/* ҂Ԃ̋ĊJ */
ER      dly_tsk(RELTIM dlytim);								/* ^XN̒x */

/* ^XNO@\ */
ER      def_tex(ID tskid, T_DTEX *pk_dtex);					/* %jp{^XNO[`̒`} */
ER      ras_tex(ID tskid, TEXPTN rasptn);					/* %jp{^XNO̗v} */
ER      dis_tex(void);										/* %jp{^XNŐ֎~} */
ER      ena_tex(void);										/* %jp{^XNŐ֎~} */
BOOL    sns_tex(void);										/* %jp{^XNO֎~Ԃ̎Q} */

/* %jp{Z}tH}%en{Semphores} */
ER      cre_sem(ID semid, const T_CSEM *pk_csem);			/**< %jp{Z}tH̐}%en{Create Semaphore} */
ER_ID   acre_sem(const T_CSEM *pk_csem);					/**< %jp{Z}tH̐(IDԍt)}%en{Create Semaphore(ID Number Automatic Assignment)} */
ER      del_sem(ID semid);									/**< %jp{Z}tH̍폜}%en{Delete Semaphore} */
ER      sig_sem(ID semid);									/**< %jp{Z}tH̕ԋp}%en{Release Semaphore Resource} */
ER      isig_sem(ID semid);									/**< %jp{Z}tH̕ԋp(^XNReLXgp)}%en{Release Semaphore Resource} */
ER      wai_sem(ID semid);									/**< %jp{Z}tH̊l}%en{Acquire Semaphore Resource} */
ER      pol_sem(ID semid);									/**< %jp{Z}tH̊l(|[O)}%en{Acquire Semaphore Resource(Polling)} */
ER      twai_sem(ID semid, TMO tmout);						/**< %jp{Z}tH̊l(^CAEg)}%en{Acquire Semaphore Resource(with Timeout)} */
ER      ref_sem(ID semid, T_RSEM *pk_rsem);					/**< %jp{Z}tH̏ԎQ}%en{Reference Semaphore State} */

/* %jp{CxgtO}%en{Eventflags} */
ER      cre_flg(ID flgid, const T_CFLG *pk_cflg);			/**< %jp{CxgtO̐}%en{Create Eventflag} */
ER_ID   acre_flg(const T_CFLG *pk_cflg);					/**< %jp{CxgtO̐(IDԍt)}%en{Create Eventflag(ID Number Automatic Assignment)} */
ER      del_flg(ID flgid);									/**< %jp{CxgtO̍폜}%en{Delete Eventflag} */
ER      set_flg(ID flgid, FLGPTN setptn);					/**< %jp{CxgtÕZbg}%en{Set Eventflag} */
ER      iset_flg(ID flgid, FLGPTN setptn);					/**< %jp{CxgtÕZbg(^XNReLXgp)}%en{Set Eventflag} */
ER      clr_flg(ID flgid, FLGPTN clrptn);					/**< %jp{CxgtÕNA}%en{Clear Eventflag} */
ER      wai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn);
															/**< %jp{CxgtO҂}%en{Wait for Eventflag} */
ER      pol_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn);
															/**< %jp{CxgtO҂(|[O)}%en{Wait for Eventflag(Polling)} */
ER      twai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn, TMO tmout);
															/**< %jp{CxgtO҂(^CAEg)}%en{Wait for Eventflag(with Timeout)} */
ER      ref_flg(ID flgid, T_RFLG *pk_rflg);					/**< %jp{CxgtȌԎQ}%en{Reference Eventflag State} */

/* %jp{f[^L[}%en{Data queue} */
ER      cre_dtq(ID dtqid, const T_CDTQ *pk_cdtq);			/**< %jp{f[^L[̐} */
ER_ID   acre_dtq(const T_CDTQ *pk_cdtq);					/**< %jp{f[^L[̐(IDԍt)} */
ER      kernel_cre_dtq(ID dtqid, const T_CDTQ *pk_cdtq);	/**< %jp{f[^L[̐(J[l֐)} */
ER      del_dtq(ID dtqid);									/**< %jp{f[^L[̍폜} */
ER      snd_dtq(ID dtqid, VP_INT data);						/**< %jp{f[^L[ւ̑M} */
ER      psnd_dtq(ID dtqid, VP_INT data);					/**< %jp{f[^L[ւ̑M(|[O)} */
ER      ipsnd_dtq(ID dtqid, VP_INT data);					/**< %jp{f[^L[ւ̑M(|[O ^XNReLXgp)} */
ER      tsnd_dtq(ID dtqid, VP_INT data, TMO tmout);			/**< %jp{f[^L[ւ̑M(^CAEg)} */
ER      fsnd_dtq(ID dtqid, VP_INT data);					/**< %jp{f[^L[ւ̋M} */
#define ifsnd_dtq	fsnd_dtq								/**< %jp{f[^L[ւ̋M(^XNReLXgp}N)} */
ER      rcv_dtq(ID dtqid, VP_INT *p_data);					/**< %jp{f[^L[̎M} */
ER      prcv_dtq(ID dtqid, VP_INT *p_data);					/**< %jp{f[^L[̎M(|[O)} */
ER      trcv_dtq(ID dtqid, VP_INT *p_data, TMO tmout);		/**< %jp{f[^L[̎M(^CAEg)} */
ER      ref_dtq(ID dtqid, T_RDTQ *pk_rdtq);					/**< %jp{f[^L[̏ԎQ} */

/* %jp{[{bNX}%en{Mailboxes} */
ER      cre_mbx(ID semid, const T_CMBX *pk_cmbx);			/**< %jp{[{bNX̐} */
ER_ID   acre_mbx(const T_CMBX *pk_cmbx);					/**< %jp{[{bNX̐(IDԍt)} */
ER      del_mbx(ID semid);									/**< %jp{[{bNX̍폜} */
ER      snd_mbx(ID mbxid, T_MSG *pk_msg);					/**< %jp{[{bNXւ̑M} */
ER      rcv_mbx(ID mbxid, T_MSG **ppk_msg);					/**< %jp{[{bNX̎M} */
ER      prcv_mbx(ID mbxid, T_MSG **ppk_msg);				/**< %jp{[{bNX̎M(|[O)} */
ER      trcv_mbx(ID mbxid, T_MSG **ppk_msg, TMO tmout);		/**< %jp{[{bNX̎M(^CAEg)} */
ER      ref_mbx(ID mbxid, T_RMBX *pk_rmbx);					/**< %jp{[{bNX̏ԎQ} */

/* %jp{~[ebNX} */
ER      cre_mtx(ID mtxid, const T_CMTX *pk_cmtx);			/**< %jp{~[ebNX̐}%en{Create Mutex} */
ER_ID   acre_mtx(const T_CMTX *pk_cmtx);					/**< %jp{~[ebNX̐(IDԍt)}%en{Create Mutex(ID Number Automatic Assignment)} */
ER      del_mtx(ID mtxid);									/**< %jp{~[ebNX̍폜}%en{Delete Mutex} */
ER      loc_mtx(ID mtxid);									/**< %jp{~[ebNX̃bNl} */
ER      ploc_mtx(ID mtxid);									/**< %jp{~[ebNX̃bNl(|[O)} */
ER      tloc_mtx(ID mtxid, TMO tmout);						/**< %jp{~[ebNX̃bNl(^CAEg)} */
ER      unl_mtx(ID mtxid);									/**< %jp{~[ebNX̃bN} */


/* %jp{Œ蒷v[} */
ER      cre_mpf(ID mpfid, const T_CMPF *pk_cmpf);			/**< %jp{Œ蒷v[̐} */
ER_ID   acre_mpf(const T_CMPF *pk_cmpf);					/**< %jp{Œ蒷v[̐(IDԍt)} */
ER      del_mpf(ID mpfid);									/**< %jp{Œ蒷v[̍폜} */
ER      get_mpf(ID mpfid, VP *p_blk);						/**< %jp{Œ蒷ubN̊l} */
ER      pget_mpf(ID mpfid, VP *p_blk);						/**< %jp{Œ蒷ubN̊l(|[O)} */
ER      tget_mpf(ID mpfid, VP *p_blk, TMO tmout);			/**< %jp{Œ蒷ubN̊l(^CAEg)} */
ER      rel_mpf(ID mpfid, VP blk);							/**< %jp{Œ蒷ubN̕ԋp} */
ER      ref_mpf(ID mpfid, T_RMPF *pk_rmpf);					/**< %jp{Œ蒷ubN̏ԎQ} */


/* %jp{VXeԊǗ@\}%en{System Time Management} */
ER      set_tim(const SYSTIM *p_system);					/**< %jp{VXe̐ݒ}%en{Set System Time} */
ER      get_tim(SYSTIM *p_system);							/**< %jp{VXe̎Q}%en{Reference System Time} */
ER      isig_tim(void);										/**< %jp{^CeBbN̋}%en{Supply Time Tick} */

/* %jp{nh} */
ER      cre_cyc(ID cycid, const T_CCYC *pk_ccyc);			/**< %jp{nh̐} */
ER_ID   acre_cyc(const T_CCYC *pk_ccyc);					/**< %jp{nh̐(IDԍt)} */
ER      del_cyc(ID cycid);									/**< %jp{nh̍폜} */
ER      sta_cyc(ID cycid);									/**< %jp{nh̓Jn} */
ER      stp_cyc(ID cycid);									/**< %jp{nh̓~} */
ER      ref_cyc(ID cycid, T_RCYC *pk_rcyc);					/**< %jp{nh̏ԎQ} */

/* VXeԊǗ@\ */
ER      rot_rdq(PRI tskpri);								/**< %jp{^XND揇ʂ̉]} */
ER      get_tid(ID *p_tskid);								/**< %jp{sԃ^XNID̎Q} */
ER      loc_cpu(void);										/**< %jp{CPUbNԂւ̈ڍs} */
#define iloc_cpu	loc_cpu
ER      unl_cpu(void);										/**< %jp{CPUbNԂ̉} */
#define iunl_cpu	unl_cpu
ER      dis_dsp(void);										/**< %jp{fBXpb`̋֎~} */
ER      ena_dsp(void);										/**< %jp{fBXpb`̋} */
BOOL    sns_ctx(void);										/**< %jp{ReLXg̎Q} */
BOOL    sns_loc(void);										/**< %jp{CPUbNԂ̎Q} */
BOOL    sns_dsp(void);										/**< %jp{fBXpb`֎~Ԃ̎Q} */
BOOL    sns_dpn(void);										/**< %jp{ fBXpb`ۗԂ̎Q} */


ER      def_inh(INHNO inhno, const T_DINH *pk_dinh);
ER      cre_isr(ID isrid, const T_CISR *pk_cisr);			/**< %jp{݃T[rX[`̐} */
ER_ID   acre_isr(const T_CISR *pk_cisr);					/**< %jp{݃T[rX[`̐(IDԍt)} */
ER      del_isr(ID isrid);									/**< %jp{݃T[rX[`̍폜} */


ER      dis_int(INTNO intno);								/**< %jp{݂̋֎~} */
ER      ena_int(INTNO intno);								/**< %jp{݂̋} */
ER      vclr_int(INTNO intno);								/**< %jp{ݗṽNA(ƎT[rXR[)} */
ER      chg_imsk(INT imsk);									/**< %jp{݃}XN̕ύX(ˑT[rXR[)} */
ER      get_imsk(INT *p_imsk);								/**< %jp{݃}XN̎Q(ˑT[rXR[)} */
ER      vchg_ilv(INTNO intno, INT ilv);						/**< %jp{݃xύX(ƎT[rXR[)} */
ER      vget_ilv(INTNO intno, INT *p_ilv);					/**< %jp{݃xQ(ƎT[rXR[)} */


/* %jp{VXe\Ǘ@\} */
ER      ref_ver(T_RVER *pk_rver);							/**< %jp{o[Wԍ̎Q} */


/* %jp{J[ltbN֐} */
void    _kernel_tsk_swi(ID tskid_old, ID tskid_new);		/**< %jp{^XNXCb`̃tbN} */
void    _kernel_inh_sta(INHNO inhno);						/**< %jp{݃nhJñtbN} */
void    _kernel_inh_end(INHNO inhno);						/**< %jp{݃nhĨtbN} */
void    _kernel_isr_sta(INTNO intno);						/**< %jp{݃T[rX[`JñtbN} */
void    _kernel_isr_end(INTNO intno);						/**< %jp{݃T[rX[`ĨtbN} */


#ifdef __cplusplus
}
#endif


#endif /* _KERNEL__kernel_h__ */



/* end of file */
