/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  itron.h
 * @brief %en{uITRON4.0 standard header file}%jp{ITRON4.0p̕Wwb_t@C}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef _KERNEL__itron_h__
#define _KERNEL__itron_h__



/* ------------------------------------ */
/*             Constants                */
/* ------------------------------------ */

/* %jp{}%en{General Constants} */
#ifndef NULL
#ifdef __cplusplus
#define NULL					0						/**< %jp{|C^}%en{Invalid pointer} */
#else
#define NULL					((void *)0)				/**< %jp{|C^}%en{Invalid pointer} */
#endif
#endif


#define TRUE					1						/**< %jp{^}%en{True} */
#define FALSE					0						/**< %jp{U}%en{Flase} */
#define E_OK					0						/**< %jp{I}%en{Normal completion} */


/* %jp{IuWFNg}%en{Object Attributes} */
#define TA_NULL					0						/**< %jp{IuWFNgw肵Ȃ}%en{Object attribute unspecified} */
#define TA_HLNG					0x00					/**< %jp{p̃C^[tF[XŏPʂN}%en{Start a processing unit through a high-level language interface} */
#define TA_ASM					0x01					/**< %jp{AZup̃C^[tF[XŏPʂN}%en{Start a processing unit through an assembly language interface} */

#define TA_TFIFO				0x00					/**< %jp{^XN̑҂sFIFO}%en{Task wait queue is in FIFO order} */
#define TA_TPRI					0x01					/**< %jp{^XN̑҂s^XN̗Dx}%en{Task wait queue is in task priority order} */

#define TA_MFIFO				0x00					/**< %jp{bZ[W̑҂sFIFO}%en{Message queue is in FIFO order} */
#define TA_MPRI					0x02					/**< %jp{bZ[W̑҂sbZ[W̗Dx}%en{Message queue is in message priority order} */

#define TA_ACT					0x02					/**< %jp{^XNNꂽԂŐ}%en{Task is activated after the creation} */
#define TA_RSTR					0x04					/**< %jp{^XN}%en{Restricted task} */

#define TA_WSGL					0x00					/**< %jp{CxgtO𕡐̃^XN҂ƂȂ}%en{Only one task is allowed to be in the waiting state for the eventflag} */
#define TA_WMUL					0x02					/**< %jp{CxgtO𕡐̃^XN҂Ƃ}%en{Multiple tasks are allowed to be in the waiting state for the eventflag} */
#define TA_CLR					0x04					/**< %jp{҂ɃCxgtONA}%en{Eventflag's bit pattern is cleared when a task is released from the waiting state for that eventflag} */

#define TA_INHERIT				0x02					/**< %jp{~[ebNXDxpvgRT|[g}%en{Mutex uses the priority inheritance protocol} */
#define TA_CEILING				0x03					/**< %jp{~[ebNXDxvgRT|[g}%en{Mutex uses the priority ceiling protocol} */

#define TA_STA					0x02					/**< %jp{nh𓮍삵ĂԂŐ}%en{Cyclic handler is in an operational state after the creation} */
#define TA_PHS					0x04					/**< %jp{nḧʑۑ}%en{Cyclic handler is activated preserving the activation phase} */


/* %jp{^CAEgw} */
#define TMO_POL					0						/**< %jp{|[O}%en{Polling} */
#define TMO_FEVR				(-1)					/**< %jp{iv҂}%en{Waiting forever} */
#define TMO_NBLK				(-2)					/**< %jp{mubLO}%en{Non-blocking} */


/* %jp{T[rXR[̓샂[h}%en{Service Call Operational Mode} */
#define TWF_ANDW				0x00					/**< %jp{CxgtOAND҂}%en{AND waiting condition for eventflag} */
#define TWF_ORW					0x01					/**< %jp{CxgtOOR҂}%en{OR waiting condition for eventflag} */


/* %jp{IuWFNg̏}%en{Object State} */
#define TTS_RUN					0x01					/**< %jp{s}%en{RUNNING state} */
#define TTS_RDY					0x02					/**< %jp{s\}%en{READY state} */
#define TTS_WAI					0x04					/**< %jp{҂}%en{WAITING state} */
#define TTS_SUS					0x08					/**< %jp{҂}%en{SUSPENDED state} */
#define TTS_WAS					0x0c					/**< %jp{d҂}%en{WAITING-SUSPENDED state} */
#define TTS_DMT					0x10					/**< %jp{x~}%en{DORMANT state} */

#define TTW_SLP					0x0001					/**< %jp{N҂}%en{} */
#define TTW_DLY					0x0002					/**< %jp{Ԍoߑ҂}%en{} */
#define TTW_SEM					0x0004					/**< %jp{Z}tH̊l҂}%en{} */
#define TTW_FLG					0x0008					/**< %jp{CxgtO҂}%en{} */
#define TTW_SDTQ				0x0010					/**< %jp{f[^L[ւ̑M҂}%en{} */
#define TTW_RDTQ				0x0020					/**< %jp{f[^L[̎M҂}%en{} */
#define TTW_MBX					0x0040					/**< %jp{[{bNX̎M҂}%en{} */
#define TTW_MTX					0x0080					/**< %jp{~[ebNX̃bN҂}%en{} */
#define TTW_SMBF				0x0100					/**< %jp{bZ[Wobt@ւ̑M҂}%en{} */
#define TTW_RMBF				0x0200					/**< %jp{bZ[Wobt@̎M҂}%en{} */
#define TTW_CAL					0x0400					/**< %jp{fǔĂяo҂}%en{} */
#define TTW_ACP					0x0800					/**< %jp{fu̎t҂}%en{} */
#define TTW_RDV					0x1000					/**< %jp{fȕI҂}%en{} */
#define TTW_MPF					0x2000					/**< %jp{Œ蒷ubN̊l҂}%en{} */
#define TTW_MPL					0x4000					/**< %jp{ϒubN̊l҂}%en{} */

#define TTEX_ENA				0x00					/**< %jp{^XN̗O}%en{} */
#define TTEX_DIS				0x01					/**< %jp{^XNO֎~}%en{} */

#define TCYC_STP				0x00					/**< %jp{nh삵ĂȂ}%en{} */
#define TCYC_STA				0x01					/**< %jp{nh삵Ă}%en{} */

#define TALM_STP				0x00					/**< %jp{A[nh삵ĂȂ}%en{} */
#define TALM_STA				0x00					/**< %jp{A[nh삵Ă} */

#define TOVR_STP				0x00					/**< %jp{vZbTԂݒ肳ĂȂ}%en{} */
#define TOVR_STA				0x01					/**< %jp{vZbTԂݒ肳Ă}%en{} */

/* %jp{̑̒萔}%en{Other constants} */
#define TSK_SELF				0						/**< %jp{^XNw}%en{} */
#define TSK_NONE				0						/**< %jp{Y^XN}%en{} */

#define TPRI_SELF				0						/**< %jp{^XÑx[XDx̎w}%en{} */
#define TPRI_INI				0						/**< %jp{^XN̋NDx̎w}%en{} */


/* %jp{G[R[h}%en{Error code} */
#define E_SYS					(-5)					/**< %jp{VXeG[}%en{System error} */
#define E_NOSPT					(-9)					/**< %jp{T|[g@\}%en{Unsupported function} */
#define E_RSFN					(-10)					/**< %jp{\@\R[h}%en{Reserved function code} */
#define E_RSATR					(-11)					/**< %jp{\񑮐}%en{Reserved attribute} */
#define E_PAR					(-17)					/**< %jp{p[^G[}%en{Parameter error} */
#define E_ID					(-18)					/**< %jp{sIDԍ}%en{Invalid ID number} */
#define E_CTX					(-25)					/**< %jp{ReLXgG[}%en{Context error} */
#define E_MACV					(-26)					/**< %jp{ANZXᔽ}%en{} */
#define E_OACV					(-27)					/**< %jp{IuWFNgANZXᔽ}%en{} */
#define E_ILUSE					(-28)					/**< %jp{T[rXR[sgp}%en{} */
#define E_NOMEM					(-33)					/**< %jp{s}%en{} */
#define E_NOID					(-34)					/**< %jp{IDԍs}%en{} */
#define E_OBJ					(-41)					/**< %jp{IuWFNgԃG[}%en{} */
#define E_NOEXS					(-42)					/**< %jp{IuWFNg}%en{} */
#define E_QOVR					(-43)					/**< %jp{L[COI[o[t[}%en{} */
#define E_RLWAI					(-49)					/**< %jp{҂Ԃ̋}%en{} */
#define E_TMOUT					(-50)					/**< %jp{|[Os܂̓^CAEg}%en{} */
#define E_DLT					(-51)					/**< %jp{҂IuWFNg̍폜}%en{} */
#define E_CLS					(-52)					/**< %jp{҂IuWFNg̏ԕω}%en{} */
#define E_WBLK					(-57)					/**< %jp{mubLOt}%en{} */
#define E_BOVR					(-58)					/**< %jp{obt@I[o[t[}%en{} */



#define TMIN_TPRI				1
#define TMIN_MPRI				1




/* ------------------------------------ */
/*     Include configulation file       */
/* ------------------------------------ */

#include "core/basetyp.h"
#include "config/cfgsys.h"
#include "parser/parssys.h"




/* ------------------------------------ */
/*             Data type                */
/* ------------------------------------ */

/* %jp{v~eBu^`} */
typedef _KERNEL_T_B				B;						/**< %jp{t 8rbg}%en{Signed  8-bit integer} */
typedef _KERNEL_T_H				H;						/**< %jp{t16rbg}%en{Signed 16-bit integer} */
typedef _KERNEL_T_W				W;						/**< %jp{t32rbg}%en{Signed 32-bit integer} */
#if _KERNEL_ENABLE64
typedef _KERNEL_T_D				D;						/**< %jp{t64rbg}%en{Signed 64-bit integer} */
#endif

typedef _KERNEL_T_UB			UB;						/**< %jp{ 8rbg}%en{Unsigned  8-bit integer} */
typedef _KERNEL_T_UH			UH;						/**< %jp{16rbg}%en{Unsigned 16-bit integer} */
typedef _KERNEL_T_UW			UW;						/**< %jp{32rbg}%en{Unsigned 32-bit integer} */
#if _KERNEL_ENABLE64
typedef _KERNEL_T_UD			UD;						/**< %jp{t64rbg}%en{Signed 64-bit integer} */
#endif

typedef B						VB;						/**< %jp{f[^^Cv܂Ȃ 8rbg̒l}%en{ 8-bit value with unknown data type} */
typedef H						VH;						/**< %jp{f[^^Cv܂Ȃ16rbg̒l}%en{16-bit value with unknown data type} */
typedef W						VW;						/**< %jp{f[^^Cv܂Ȃ32rbg̒l}%en{32-bit value with unknown data type} */
#if _KERNEL_ENABLE64
typedef D						VD;						/**< %jp{f[^^Cv܂Ȃ64rbg̒l}%en{64-bit value with unknown data type} */
#endif



/* %jp{INT^`} */
#if _KERNEL_TBIT_INT == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		INT;					/**< %jp{vZbTɎRȃTCY̕t}%en{Signed integer for the processor} */
#define _KERNEL_TMIN_INT		_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_INT		_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_INT == 8			/* 8-bit */

typedef _KERNEL_T_B				INT;					/**< %jp{vZbTɎRȃTCY̕t}%en{Signed integer for the processor} */
#define _KERNEL_TMIN_INT		_KERNEL_TMIN_B
#define _KERNEL_TMAX_INT		_KERNEL_TMAX_B

#elif _KERNEL_TBIT_INT == 16			/* 16-bit */

typedef _KERNEL_T_H				INT;					/**< %jp{vZbTɎRȃTCY̕t}%en{Signed integer for the processor} */
#define _KERNEL_TMIN_INT		_KERNEL_TMIN_H
#define _KERNEL_TMAX_INT		_KERNEL_TMAX_H

#elif _KERNEL_TBIT_INT == 32			/* 32-bit */

typedef _KERNEL_T_W				INT;					/**< %jp{vZbTɎRȃTCY̕t}%en{Signed integer for the processor} */
#define _KERNEL_TMIN_INT		_KERNEL_TMIN_W
#define _KERNEL_TMAX_INT		_KERNEL_TMAX_W

#elif _KERNEL_TBIT_INT == 64			/* 64-bit */

typedef _KERNEL_T_D				INT;					/**< %jp{vZbTɎRȃTCY̕t}%en{Signed integer for the processor} */
#define _KERNEL_TMIN_INT		_KERNEL_TMIN_D
#define _KERNEL_TMAX_INT		_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_INT

#endif



/* %jp{UINT^`} */
#if _KERNEL_TBIT_UINT == _KERNEL_TBIT_PROC_UINT

typedef _KERNEL_T_PROC_UINT		UINT;					/**< %jp{vZbTɎRȃTCY̕t}%en{Unsigned integer for the processor}  */
#define _KERNEL_TMIN_UINT		_KERNEL_TMIN_PROC_UINT
#define _KERNEL_TMAX_UINT		_KERNEL_TMAX_PROC_UINT

#elif _KERNEL_TBIT_UINT == 8			/* 8-bit */

typedef _KERNEL_T_UB			UINT;					/**< %jp{vZbTɎRȃTCY̕t}%en{Unsigned integer for the processor}  */
#define _KERNEL_TMIN_UINT		_KERNEL_TMIN_UB
#define _KERNEL_TMAX_UINT		_KERNEL_TMAX_UB

#elif _KERNEL_TBIT_UINT == 16		/* 16-bit */

typedef _KERNEL_T_UH			UINT;					/**< %jp{vZbTɎRȃTCY̕t}%en{Unsigned integer for the processor} */
#define _KERNEL_TMIN_UINT		_KERNEL_TMIN_UH
#define _KERNEL_TMAX_UINT		_KERNEL_TMAX_UH

#elif _KERNEL_TBIT_UINT == 32		/* 32-bit */

typedef _KERNEL_T_UW			UINT;					/**< %jp{vZbTɎRȃTCY̕t}%en{Unsigned integer for the processor} */
#define _KERNEL_TMIN_UINT		_KERNEL_TMIN_UW
#define _KERNEL_TMAX_UINT		_KERNEL_TMAX_UW

#elif _KERNEL_TBIT_UINT == 64		/* 64-bit */

typedef _KERNEL_T_UD			UINT;					/**< %jp{vZbTɎRȃTCY̕t}%en{Unsigned integer for the processor} */
#define _KERNEL_TMIN_UINT		_KERNEL_TMIN_UD
#define _KERNEL_TMAX_UINT		_KERNEL_TMAX_UD

#else								/* error */

#error Illegal value : _KERNEL_TBIT_UINT

#endif



/* %jp{|C^^} */
typedef _KERNEL_T_VP			VP;						/**< %jp{f[^^Cv܂Ȃ̂ւ̃|C^}%en{Pointer to an unknown data type} */



/* %jp{֐|C^^} */
typedef void					(*FP)();				/**< %jp{vŐNԒn(|C^)}%en{Processing unit start address(pointer to a function)} */
#define _KERNEL_TBIT_FP			_KERNEL_TBIT_VP



/* %jp{|C^i[ł鐮^} */
#if _KERNEL_VP_INT_PTR		/* %jp{VP_INT|C^^ɂȂ} */

typedef _KERNEL_T_VP			VP_INT;					/**< %jp{f[^^Cv܂Ȃ̂ւ̃|C^܂̓vZbTɎRȃTCY̕t}%en{Pointer to an unknown data type, or a signed integer for the processor} */
#define _KERNEL_TBIT_VP_INT		_KERNEL_TBIT_VP

#else						/* %jp{VP_INT𐮐^ɂȂ} */

#if (_KERNEL_TMIN_INTPTR >= _KERNEL_TMIN_INT) && (_KERNEL_TMAX_INTPTR <= _KERNEL_TMAX_INT)
typedef INT						VP_INT;					/**< %jp{f[^^Cv܂Ȃ̂ւ̃|C^܂̓vZbTɎRȃTCY̕t}%en{Pointer to an unknown data type, or a signed integer for the processor} */
#define _KERNEL_TMIN_VP_INT		_KERNEL_TMIN_INT
#define _KERNEL_TMAX_VP_INT		_KERNEL_TMAX_INT
#define _KERNEL_TBIT_VP_INT		_KERNEL_TBIT_INT
#else
typedef _KERNEL_T_INTPTR		VP_INT;					/**< %jp{f[^^Cv܂Ȃ̂ւ̃|C^܂̓vZbTɎRȃTCY̕t}%en{Pointer to an unknown data type, or a signed integer for the processor} */
#define _KERNEL_TMIN_VP_INT		_KERNEL_TMIN_INTPTR
#define _KERNEL_TMAX_VP_INT		_KERNEL_TMAX_INTPTR
#define _KERNEL_TBIT_VP_INT		_KERNEL_TBIT_INTPTR
#endif

#endif



/* %jp{BOOL^`} */
#if _KERNEL_TBIT_BOOL == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		BOOL;					/**< %jp{^Ul}%en{Boolean value(TRUE or FALSE)} */
#define _KERNEL_TMIN_BOOL		_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_BOOL		_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_BOOL == 8			/* 8-bit */

typedef _KERNEL_T_B				BOOL;					/**< %jp{^Ul}%en{Boolean value(TRUE or FALSE)} */
#define _KERNEL_TMIN_BOOL		_KERNEL_TMIN_B
#define _KERNEL_TMAX_BOOL		_KERNEL_TMAX_B

#elif _KERNEL_TBIT_BOOL == 16		/* 16-bit */

typedef _KERNEL_T_H				BOOL;					/**< %jp{^Ul}%en{Boolean value(TRUE or FALSE)} */
#define _KERNEL_TMIN_BOOL		_KERNEL_TMIN_H
#define _KERNEL_TMAX_BOOL		_KERNEL_TMAX_H

#elif _KERNEL_TBIT_BOOL == 32		/* 32-bit */

typedef _KERNEL_T_W				BOOL;					/**< %jp{^Ul}%en{Boolean value(TRUE or FALSE)} */
#define _KERNEL_TMIN_BOOL		_KERNEL_TMIN_W
#define _KERNEL_TMAX_BOOL		_KERNEL_TMAX_W

#elif _KERNEL_TBIT_BOOL == 64		/* 64-bit */

typedef _KERNEL_T_D				BOOL;					/**< %jp{^Ul}%en{Boolean value(TRUE or FALSE)} */
#define _KERNEL_TMIN_BOOL		_KERNEL_TMIN_D
#define _KERNEL_TMAX_BOOL		_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_BOOL

#endif



/* %jp{@\R[h`}%en{Function code} */
#if _KERNEL_TBIT_FN == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		FN;						/**< %jp{@\R[h}%en{Function code(signed integer)} */
#define _KERNEL_TMIN_FN			_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_FN			_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_FN == 8				/* 8-bit */

typedef _KERNEL_T_B				FN;						/**< %jp{@\R[h}%en{Function code(signed integer)} */
#define _KERNEL_TMIN_FN			_KERNEL_TMIN_B
#define _KERNEL_TMAX_FN			_KERNEL_TMAX_B

#elif _KERNEL_TBIT_FN == 16			/* 16-bit */

typedef _KERNEL_T_H				FN;						/**< %jp{@\R[h}%en{Function code(signed integer)} */
#define _KERNEL_TMIN_FN			_KERNEL_TMIN_H
#define _KERNEL_TMAX_FN			_KERNEL_TMAX_H

#elif _KERNEL_TBIT_FN == 32			/* 32-bit */

typedef _KERNEL_T_W				FN;						/**< %jp{@\R[h}%en{Function code(signed integer)} */
#define _KERNEL_TMIN_FN			_KERNEL_TMIN_W
#define _KERNEL_TMAX_FN			_KERNEL_TMAX_W

#elif _KERNEL_TBIT_FN == 64			/* 64-bit */

typedef _KERNEL_T_D				FN;						/**< %jp{@\R[h}%en{Function code(signed integer)} */
#define _KERNEL_TMIN_FN			_KERNEL_TMIN_D
#define _KERNEL_TMAX_FN			_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_CFG_TBIT_FN

#endif



/* %jp{G[R[h}%en{Error code(signed integer)} */
#if _KERNEL_TBIT_ER == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		ER;						/**< %jp{G[R[h}%en{Error code(signed integer)} */
#define _KERNEL_TMIN_ER			_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_ER			_KERNEL_TMAX_PROC_INT


#elif _KERNEL_TBIT_ER == 8			/* 8-bit */

typedef _KERNEL_T_B				ER;						/**< %jp{G[R[h}%en{Error code(signed integer)} */
#define _KERNEL_TMIN_ER			_KERNEL_TMIN_B
#define _KERNEL_TMAX_ER			_KERNEL_TMAX_B

#elif _KERNEL_TBIT_ER == 16			/* 16-bit */

typedef _KERNEL_T_H				ER;						/**< %jp{G[R[h}%en{Error code(signed integer)} */
#define _KERNEL_TMIN_ER			_KERNEL_TMIN_H
#define _KERNEL_TMAX_ER			_KERNEL_TMAX_H

#elif _KERNEL_TBIT_ER == 32			/* 32-bit */

typedef _KERNEL_T_W				ER;						/**< %jp{G[R[h}%en{Error code(signed integer)} */
#define _KERNEL_TMIN_ER			_KERNEL_TMIN_W
#define _KERNEL_TMAX_ER			_KERNEL_TMAX_W

#elif _KERNEL_TBIT_ER == 64			/* 64-bit */

typedef _KERNEL_T_D				ER;						/**< %jp{G[R[h}%en{Error code(signed integer)} */
#define _KERNEL_TMIN_ER			_KERNEL_TMIN_D
#define _KERNEL_TMAX_ER			_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_ER

#endif



/* %jp{IuWFNgIDԍ}%en{Object ID number(signed integer)} */
#if _KERNEL_TBIT_ID == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		ID;						/**< %jp{IuWFNgIDԍ}%en{Object ID number(signed integer)} */
#define _KERNEL_TMIN_ID			_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_ID			_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_ID == 8			/* 8-bit */

typedef _KERNEL_T_B				ID;						/**< %jp{IuWFNgIDԍ}%en{Object ID number(signed integer)} */
#define _KERNEL_TMIN_ID			_KERNEL_TMIN_B
#define _KERNEL_TMAX_ID			_KERNEL_TMAX_B

#elif _KERNEL_TBIT_ID == 16			/* 16-bit */

typedef _KERNEL_T_H				ID;						/**< %jp{IuWFNgIDԍ}%en{Object ID number(signed integer)} */
#define _KERNEL_TMIN_ID			_KERNEL_TMIN_H
#define _KERNEL_TMAX_ID			_KERNEL_TMAX_H

#elif _KERNEL_TBIT_ID == 32			/* 32-bit */

typedef _KERNEL_T_W				ID;						/**< %jp{IuWFNgIDԍ}%en{Object ID number(signed integer)} */
#define _KERNEL_TMIN_ID			_KERNEL_TMIN_W
#define _KERNEL_TMAX_ID			_KERNEL_TMAX_W

#elif _KERNEL_TBIT_ID == 64			/* 8-bit */

typedef _KERNEL_T_D				ID;						/**< %jp{IuWFNgIDԍ}%en{Object ID number(signed integer)} */
#define _KERNEL_TMIN_ID			_KERNEL_TMIN_D
#define _KERNEL_TMAX_ID			_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_ID

#endif



/* %jp{IuWFNg}%en{Object attribute(unsigned integer)} */
#if _KERNEL_TBIT_ATR == _KERNEL_TBIT_PROC_UINT

typedef _KERNEL_T_PROC_UINT		ATR;					/**< %jp{IuWFNg}%en{Object state(unsigned integer)} */			
#define _KERNEL_TMIN_ATR		_KERNEL_TMIN_PROC_UINT
#define _KERNEL_TMAX_ATR		_KERNEL_TMAX_PROC_UINT

#elif _KERNEL_TBIT_ATR == 8			/* 8-bit */

typedef _KERNEL_T_UB			ATR;					/**< %jp{IuWFNg}%en{Object attribute(unsigned integer)} */
#define _KERNEL_TMIN_ATR		_KERNEL_TMIN_UB
#define _KERNEL_TMAX_ATR		_KERNEL_TMAX_UB

#elif _KERNEL_TBIT_ATR == 16		/* 16-bit */

typedef _KERNEL_T_UH			ATR;					/**< %jp{IuWFNg}%en{Object attribute(unsigned integer)} */
#define _KERNEL_TMIN_ATR		_KERNEL_TMIN_UH
#define _KERNEL_TMAX_ATR		_KERNEL_TMAX_UH

#elif _KERNEL_TBIT_ATR == 32		/* 32-bit */

typedef _KERNEL_T_UW			ATR;					/**< %jp{IuWFNg}%en{Object attribute(unsigned integer)} */
#define _KERNEL_TMIN_ATR		_KERNEL_TMIN_UW
#define _KERNEL_TMAX_ATR		_KERNEL_TMAX_UW

#elif _KERNEL_TBIT_ATR == 64		/* 64-bit */

typedef _KERNEL_T_UD			ATR;					/**< %jp{IuWFNg}%en{Object attribute(unsigned integer)} */
#define _KERNEL_TMIN_ATR		_KERNEL_TMIN_UD
#define _KERNEL_TMAX_ATR		_KERNEL_TMAX_UD

#else								/* error */

#error Illegal value : _KERNEL_TBIT_ATR

#endif



/* %jp{IuWFNg}%en{Object state(unsigned integer)} */
#if _KERNEL_TBIT_STAT == _KERNEL_TBIT_PROC_UINT

typedef _KERNEL_T_PROC_UINT		STAT;					/**< %jp{IuWFNg}%en{Object state(unsigned integer)} */			
#define _KERNEL_TMIN_STAT		_KERNEL_TMIN_PROC_UINT
#define _KERNEL_TMAX_STAT		_KERNEL_TMAX_PROC_UINT

#elif _KERNEL_TBIT_STAT == 8		/* 8-bit */

typedef _KERNEL_T_UB			STAT;					/**< %jp{IuWFNg}%en{Object state(unsigned integer)} */			
#define _KERNEL_TMIN_STAT		_KERNEL_TMIN_UB
#define _KERNEL_TMAX_STAT		_KERNEL_TMAX_UB

#elif _KERNEL_TBIT_STAT == 16		/* 16-bit */

typedef _KERNEL_T_UH			STAT;					/**< %jp{IuWFNg}%en{Object state(unsigned integer)} */
#define _KERNEL_TMIN_STAT		_KERNEL_TMIN_UH
#define _KERNEL_TMAX_STAT		_KERNEL_TMAX_UH

#elif _KERNEL_TBIT_STAT == 32		/* 32-bit */

typedef _KERNEL_T_UW			STAT;					/**< %jp{IuWFNg}%en{Object state(unsigned integer)} */
#define _KERNEL_TMIN_STAT		_KERNEL_TMIN_UW
#define _KERNEL_TMAX_STAT		_KERNEL_TMAX_UW

#elif _KERNEL_TBIT_STAT == 64		/* 8-bit */

typedef _KERNEL_T_UD			STAT;					/**< %jp{IuWFNg}%en{Object state(unsigned integer)} */
#define _KERNEL_TMIN_STAT		_KERNEL_TMIN_UD
#define _KERNEL_TMAX_STAT		_KERNEL_TMAX_UD

#else								/* error */

#error Illegal value : _KERNEL_CFG_TBIT_STAT

#endif



/* %jp{T[rXR[̓샂[h}%en{Service call operational mode(unsigned integer)} */
#if _KERNEL_TBIT_MODE == _KERNEL_TBIT_PROC_UINT

typedef _KERNEL_T_PROC_UINT		MODE;					/**< %jp{T[rXR[̓샂[h}%en{Service call operational mode(unsigned integer)} */
#define _KERNEL_TMIN_MODE		_KERNEL_TMIN_PROC_UINT
#define _KERNEL_TMAX_MODE		_KERNEL_TMAX_PROC_UINT

#elif _KERNEL_TBIT_MODE == 8		/* 8-bit */

typedef _KERNEL_T_UB			MODE;					/**< %jp{T[rXR[̓샂[h}%en{Service call operational mode(unsigned integer)} */
#define _KERNEL_TMIN_MODE		_KERNEL_TMIN_UB
#define _KERNEL_TMAX_MODE		_KERNEL_TMAX_UB

#elif _KERNEL_TBIT_MODE == 16		/* 16-bit */

typedef _KERNEL_T_UH			MODE;					/**< %jp{T[rXR[̓샂[h}%en{Service call operational mode(unsigned integer)} */
#define _KERNEL_TMIN_MODE		_KERNEL_TMIN_UH
#define _KERNEL_TMAX_MODE		_KERNEL_TMAX_UH

#elif _KERNEL_TBIT_MODE == 32		/* 32-bit */

typedef _KERNEL_T_UW			MODE;					/**< %jp{T[rXR[̓샂[h}%en{Service call operational mode(unsigned integer)} */
#define _KERNEL_TMIN_MODE		_KERNEL_TMIN_UW
#define _KERNEL_TMAX_MODE		_KERNEL_TMAX_UW

#elif _KERNEL_TBIT_MODE == 64		/* 8-bit */

typedef _KERNEL_T_UD			MODE;					/**< %jp{T[rXR[̓샂[h}%en{Service call operational mode(unsigned integer)} */
#define _KERNEL_TMIN_MODE		_KERNEL_TMIN_UD
#define _KERNEL_TMAX_MODE		_KERNEL_TMAX_UD

#else								/* error */

#error Illegal value : _KERNEL_TBIT_MODE

#endif



/* %jp{Dx}%en{Priority(signed integer)} */
#if _KERNEL_TBIT_PRI == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		PRI;					/**< %jp{Dx(t)}%en{Priority(signed integer)} */
#define _KERNEL_TMIN_PRI		_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_PRI		_KERNEL_TMAX_PROC_INT

#elif _KERNEL_CFG_TBIT_PRI == 8		/* 8-bit */

typedef _KERNEL_T_B				PRI;					/**< %jp{Dx(t)}%en{Priority(signed integer)} */
#define _KERNEL_TMIN_PRI		_KERNEL_TMIN_B
#define _KERNEL_TMAX_PRI		_KERNEL_TMAX_B

#elif _KERNEL_CFG_TBIT_PRI == 16	/* 16-bit */

typedef _KERNEL_T_H				PRI;					/**< %jp{Dx(t)}%en{Priority(signed integer)} */
#define _KERNEL_TMIN_PRI		_KERNEL_TMIN_H
#define _KERNEL_TMAX_PRI		_KERNEL_TMAX_H

#elif _KERNEL_CFG_TBIT_PRI == 32	/* 32-bit */

typedef _KERNEL_T_W				PRI;					/**< %jp{Dx(t)}%en{Priority(signed integer)} */
#define _KERNEL_TMIN_PRI		_KERNEL_TMIN_W
#define _KERNEL_TMAX_PRI		_KERNEL_TMAX_W

#elif _KERNEL_CFG_TBIT_PRI == 64	/* 8-bit */

typedef _KERNEL_T_D				PRI;					/**< %jp{Dx(t)}%en{Priority(signed integer)} */
#define _KERNEL_TMIN_PRI		_KERNEL_TMIN_D
#define _KERNEL_TMAX_PRI		_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_PRI

#endif



/* %jp{̈̃TCY()}%en{Memory area size(unsigned integer)} */
#if _KERNEL_TBIT_SIZE == _KERNEL_TBIT_PROC_UINT

typedef _KERNEL_T_PROC_UINT		SIZE;					/**< %jp{̈̃TCY()}%en{Memory area size(unsigned integer)} */
#define _KERNEL_TMIN_SIZE		_KERNEL_TMIN_PROC_UINT
#define _KERNEL_TMAX_SIZE		_KERNEL_TMAX_PROC_UINT

#elif _KERNEL_TBIT_SIZE == 8		/* 8-bit */

typedef _KERNEL_T_UB			SIZE;					/**< %jp{̈̃TCY()}%en{Memory area size(unsigned integer)} */		
#define _KERNEL_TMIN_SIZE		_KERNEL_TMIN_UB
#define _KERNEL_TMAX_SIZE		_KERNEL_TMAX_UB

#elif _KERNEL_TBIT_SIZE == 16		/* 16-bit */

typedef _KERNEL_T_UH			SIZE;					/**< %jp{̈̃TCY()}%en{Memory area size(unsigned integer)} */
#define _KERNEL_TMIN_SIZE		_KERNEL_TMIN_UH
#define _KERNEL_TMAX_SIZE		_KERNEL_TMAX_UH

#elif _KERNEL_TBIT_SIZE == 32		/* 32-bit */

typedef _KERNEL_T_UW			SIZE;					/**< %jp{̈̃TCY()}%en{Memory area size(unsigned integer)} */
#define _KERNEL_TMIN_SIZE		_KERNEL_TMIN_UW
#define _KERNEL_TMAX_SIZE		_KERNEL_TMAX_UW

#elif _KERNEL_TBIT_SIZE == 64		/* 8-bit */

typedef _KERNEL_T_UD			SIZE;					/**< %jp{̈̃TCY()}%en{Memory area size(unsigned integer)} */
#define _KERNEL_TMIN_SIZE		_KERNEL_TMIN_UD
#define _KERNEL_TMAX_SIZE		_KERNEL_TMAX_UD

#else								/* error */

#error Illegal value : _KERNEL_TBIT_SIZE

#endif



/* %jp{^CAEg}%en{Timeout} */
#if _KERNEL_TBIT_TMO == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		TMO;					/**< %jp{^CAEg}%en{Timeout} */
#define _KERNEL_TMIN_TMO		_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_TMO		_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_TMO == 8			/* 8-bit */

typedef _KERNEL_T_B				TMO;					/**< %jp{^CAEg}%en{Timeout} */
#define _KERNEL_TMIN_TMO		_KERNEL_TMIN_B
#define _KERNEL_TMAX_TMO		_KERNEL_TMAX_B

#elif _KERNEL_TBIT_TMO == 16		/* 16-bit */

typedef _KERNEL_T_H				TMO;					/**< %jp{^CAEg}%en{Timeout} */
#define _KERNEL_TMIN_TMO		_KERNEL_TMIN_H
#define _KERNEL_TMAX_TMO		_KERNEL_TMAX_H

#elif _KERNEL_TBIT_TMO == 32			/* 32-bit */

typedef _KERNEL_T_W				TMO;					/**< %jp{^CAEg}%en{Timeout} */
#define _KERNEL_TMIN_TMO		_KERNEL_TMIN_W
#define _KERNEL_TMAX_TMO		_KERNEL_TMAX_W

#elif _KERNEL_TBIT_TMO == 64			/* 8-bit */

typedef _KERNEL_T_D				TMO;					/**< %jp{^CAEg}%en{Timeout} */
#define _KERNEL_TMIN_TMO		_KERNEL_TMIN_D
#define _KERNEL_TMAX_TMO		_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_TMO

#endif



/* %jp{Ύ(, ԒPʂ͎`)}%en{Relative time(unsigned integer, unit of time is implementation-defined)} */
#if _KERNEL_TBIT_RELTIM == _KERNEL_TBIT_PROC_UINT

typedef _KERNEL_T_PROC_UINT		RELTIM;					/**< %jp{Ύ(, ԒPʂ͎`)}%en{Relative time(unsigned integer, unit of time is implementation-defined)} */
#define _KERNEL_TMIN_RELTIM		_KERNEL_TMIN_PROC_UINT
#define _KERNEL_TMAX_RELTIM		_KERNEL_TMAX_PROC_UINT

#elif _KERNEL_TBIT_RELTIM == 8		/* 8-bit */

typedef _KERNEL_T_UB			RELTIM;					/**< %jp{Ύ(, ԒPʂ͎`)}%en{Relative time(unsigned integer, unit of time is implementation-defined)} */		
#define _KERNEL_TMIN_RELTIM		_KERNEL_TMIN_UB
#define _KERNEL_TMAX_RELTIM		_KERNEL_TMAX_UB

#elif _KERNEL_TBIT_RELTIM == 16		/* 16-bit */

typedef _KERNEL_T_UH			RELTIM;					/**< %jp{Ύ(, ԒPʂ͎`)}%en{Relative time(unsigned integer, unit of time is implementation-defined)} */
#define _KERNEL_TMIN_RELTIM		_KERNEL_TMIN_UH
#define _KERNEL_TMAX_RELTIM		_KERNEL_TMAX_UH

#elif _KERNEL_TBIT_RELTIM == 32		/* 32-bit */

typedef _KERNEL_T_UW			RELTIM;					/**< %jp{Ύ(, ԒPʂ͎`)}%en{Relative time(unsigned integer, unit of time is implementation-defined)} */
#define _KERNEL_TMIN_RELTIM		_KERNEL_TMIN_UW
#define _KERNEL_TMAX_RELTIM		_KERNEL_TMAX_UW

#elif _KERNEL_TBIT_RELTIM == 64		/* 8-bit */

typedef _KERNEL_T_UD			RELTIM;					/**< %jp{Ύ(, ԒPʂ͎`)}%en{Relative time(unsigned integer, unit of time is implementation-defined)} */
#define _KERNEL_TMIN_RELTIM		_KERNEL_TMIN_UD
#define _KERNEL_TMAX_RELTIM		_KERNEL_TMAX_UD

#else								/* error */

#error Illegal value : _KERNEL_TBIT_RELTIM

#endif



/* %jp{VXe(, ԒPʂ͎`)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
#if _KERNEL_SYSTIM_STRUCT

#if _KERNEL_TBIT_SYSTIM == 16		/* 16-bit */

/** %jp{VXe(, ԒPʂ͎`)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
typedef struct t_systim
{
	UH ltime;				/**< %jp{ 16bit}%en{lower 16bit} */
} SYSTIM;

#define _KERNEL_SYSTIM_ADD(t, n)	do { (t)->ltime += n; } while(0)

#elif _KERNEL_TBIT_SYSTIM == 32		/* 32-bit */

/** %jp{VXe(, ԒPʂ͎`)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
typedef struct t_systim
{
	UW ltime;				/**< %jp{ 32bit}%en{lower 32bit} */
} SYSTIM;

#define _KERNEL_SYSTIM_ADD(t, n)	do { (t)->ltime += n; } while(0)

#elif _KERNEL_CFG_TBIT_SYSTIM == 48	/* 48-bit */

/** %jp{VXe(, ԒPʂ͎`)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
typedef struct t_systim		
{
	UW ltime;				/**< %jp{ 32bit}%en{lower 32bit} */
	UH utime;				/**< %jp{ 16bit}%en{upper 16bit} */
} SYSTIM;


#define _KERNEL_SYSTIM_ADD(t, n)	do { if ( (t)->ltime + (n) < (t)->ltime ) { (t)->utime++; } (t)->ltime += (n); } while(0)

#elif _KERNEL_TBIT_SYSTIM == 64		/* 64-bit */

/** %jp{VXe(, ԒPʂ͎`)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
typedef struct t_systim
{
	UW ltime;				/**< %en{lower}%jp{ 32bit} */
	UW utime;				/**< %en{upper}%jp{ 32bit} */
} SYSTIM;

#define _KERNEL_SYSTIM_ADD(t, n)	do { if ( (t)->ltime + (n) < (t)->ltime ) { (t)->utime++; } (t)->ltime += (n); } while(0)

#elif _KERNEL_TBIT_SYSTIM == 96		/* 96-bit */

/** %jp{VXe(, ԒPʂ͎`)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
typedef struct t_systim
{
	UD ltime;				/**< %en{lower}%jp{ 64bit} */
	UW utime;				/**< %en{upper}%jp{ 32bit} */
} SYSTIM;

#define _KERNEL_SYSTIM_ADD(t, n)	do { if ( (t)->ltime + (n) < (t)->ltime ) { (t)->utime++; } (t)->ltime += (n); } while(0)

#elif _KERNEL_TBIT_SYSTIM == 128	/* 128-bit */

/** %jp{VXe(, ԒPʂ͎`)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
typedef struct t_systim
{
	UD ltime;				/**< %en{lower}%jp{ 64bit} */
	UD utime;				/**< %en{upper}%jp{ 32bit} */
} SYSTIM;

#define _KERNEL_SYSTIM_ADD(t, n)	do { if ( (t)->ltime + (n) < (t)->ltime ) { (t)->utime++; } (t)->ltime += (n); } while(0)

#else

#error Illegal value : _KERNEL_TBIT_SYSTIM

#endif

#else

#if _KERNEL_CFG_TBIT_SYSTIM == _KERNEL_TBIT_PROC_UINT		/* default */

typedef _KERNEL_T_PROC_UINT		SYSTIM;					/**< %jp{VXe(, ԒPʂ͎`)}%en{System time(unsigned integer, unit of time is implementation-defined)} */

#elif _KERNEL_TBIT_SYSTIM == 16	/* 16-bit */

typedef _KERNEL_T_UH			SYSTIM;					/**< %jp{VXe(, ԒPʂ͎`)}%en{System time(unsigned integer, unit of time is implementation-defined)} */

#elif _KERNEL_TBIT_SYSTIM == 32	/* 32-bit */

typedef _KERNEL_T_UW			SYSTIM;					/**< %jp{VXe(, ԒPʂ͎`)}%en{System time(unsigned integer, unit of time is implementation-defined)} */

#elif _KERNEL_TBIT_SYSTIM == 64	/* 64-bit */

typedef _KERNEL_T_UD			SYSTIM;					/**< %jp{VXe(, ԒPʂ͎`)}%en{System time(unsigned integer, unit of time is implementation-defined)} */

#else							/* error */

#error Illegal value : _KERNEL_TBIT_SYSTIM

#endif

#define _KERNEL_SYSTIM_ADD(t, n)	do { *(t) += n; } while(0)

#endif



/* %jp{G[R[h܂͐^Ul}%en{Error code or a boolean value} */
#if _KERNEL_TBIT_ER_BOOL == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		ER_BOOL;				/**< %jp{G[R[h܂͐^Ul}%en{Error code or a boolean value} */
#define _KERNEL_TMIN_ER_BOOL	_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_ER_BOOL	_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_ER_BOOL == 8		/* 8-bit */

typedef _KERNEL_T_B				ER_BOOL;				/**< %jp{G[R[h܂͐^Ul}%en{Error code or a boolean value} */
#define _KERNEL_TMIN_ER_BOOL	_KERNEL_TMIN_B
#define _KERNEL_TMAX_ER_BOOL	_KERNEL_TMAX_B

#elif _KERNEL_TBIT_ER_BOOL == 16	/* 16-bit */

typedef _KERNEL_T_H				ER_BOOL;				/**< %jp{G[R[h܂͐^Ul}%en{Error code or a boolean value} */
#define _KERNEL_TMIN_ER_BOOL	_KERNEL_TMIN_H
#define _KERNEL_TMAX_ER_BOOL	_KERNEL_TMAX_H

#elif _KERNEL_TBIT_ER_BOOL == 32	/* 32-bit */

typedef _KERNEL_T_W				ER_BOOL;				/**< %jp{G[R[h܂͐^Ul}%en{Error code or a boolean value} */
#define _KERNEL_TMIN_ER_BOOL	_KERNEL_TMIN_W
#define _KERNEL_TMAX_ER_BOOL	_KERNEL_TMAX_W

#elif _KERNEL_TBIT_ER_BOOL == 64	/* 8-bit */

typedef _KERNEL_T_D				ER_BOOL;				/**< %jp{G[R[h܂͐^Ul}%en{Error code or a boolean value} */
#define _KERNEL_TMIN_ER_BOOL	_KERNEL_TMIN_D
#define _KERNEL_TMAX_ER_BOOL	_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_ER_BOOL

#endif



/* %jp{G[R[h܂IDԍ}%en{Error code or an object ID number} */
#if _KERNEL_TBIT_ER_ID == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		ER_ID;					/**< %jp{G[R[h܂IDԍ}%en{Error code or an object ID number} */
#define _KERNEL_TMIN_ER_ID		_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_ER_ID		_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_ER_ID == 8		/* 8-bit */

typedef _KERNEL_T_B				ER_ID;					/**< %jp{G[R[h܂IDԍ}%en{Error code or an object ID number} */
#define _KERNEL_TMIN_ER_ID		_KERNEL_TMIN_B
#define _KERNEL_TMAX_ER_ID		_KERNEL_TMAX_B

#elif _KERNEL_TBIT_ER_ID == 16		/* 16-bit */

typedef _KERNEL_T_H				ER_ID;					/**< %jp{G[R[h܂IDԍ}%en{Error code or an object ID number} */
#define _KERNEL_TMIN_ER_ID		_KERNEL_TMIN_H
#define _KERNEL_TMAX_ER_ID		_KERNEL_TMAX_H

#elif _KERNEL_TBIT_ER_ID == 32		/* 32-bit */

typedef _KERNEL_T_W				ER_ID;					/**< %jp{G[R[h܂IDԍ}%en{Error code or an object ID number} */
#define _KERNEL_TMIN_ER_ID		_KERNEL_TMIN_W
#define _KERNEL_TMAX_ER_ID		_KERNEL_TMAX_W

#elif _KERNEL_TBIT_ER_ID == 64		/* 8-bit */

typedef _KERNEL_T_D				ER_ID;					/**< %jp{G[R[h܂IDԍ}%en{Error code or an object ID number} */
#define _KERNEL_TMIN_ER_ID		_KERNEL_TMIN_D
#define _KERNEL_TMAX_ER_ID		_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_ER_ID

#endif



/* %jp{G[R[h܂͕(̗LrbgUINT1rbgZ)}%en{Error code or an unsigned integer} */
#if _KERNEL_TBIT_ER_UINT == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		ER_UINT;				/**< %jp{G[R[h܂͕(̗LrbgUINT1rbgZ)}%en{Error code or an unsigned integer} */
#define _KERNEL_TMIN_ER_UINT	_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_ER_UINT	_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_ER_UINT == 8		/* 8-bit */

typedef _KERNEL_T_B				ER_UINT;				/**< %jp{G[R[h܂͕(̗LrbgUINT1rbgZ)}%en{Error code or an unsigned integer} */
#define _KERNEL_TMIN_ER_UINT	_KERNEL_TMIN_B
#define _KERNEL_TMAX_ER_UINT	_KERNEL_TMAX_B

#elif _KERNEL_TBIT_ER_UINT == 16	/* 16-bit */

typedef _KERNEL_T_H				ER_UINT;				/**< %jp{G[R[h܂͕(̗LrbgUINT1rbgZ)}%en{Error code or an unsigned integer} */
#define _KERNEL_TMIN_ER_UINT	_KERNEL_TMIN_H
#define _KERNEL_TMAX_ER_UINT	_KERNEL_TMAX_H

#elif _KERNEL_TBIT_ER_UINT == 32	/* 32-bit */

typedef _KERNEL_T_W				ER_UINT;				/**< %jp{G[R[h܂͕(̗LrbgUINT1rbgZ)}%en{Error code or an unsigned integer} */
#define _KERNEL_TMIN_ER_UINT	_KERNEL_TMIN_W
#define _KERNEL_TMAX_ER_UINT	_KERNEL_TMAX_W

#elif _KERNEL_TBIT_ER_UINT == 64	/* 8-bit */

typedef _KERNEL_T_D				ER_UINT;				/**< %jp{G[R[h܂͕(̗LrbgUINT1rbgZ)}%en{Error code or an unsigned integer} */
#define _KERNEL_TMIN_ER_UINT	_KERNEL_TMIN_D
#define _KERNEL_TMAX_ER_UINT	_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_ER_UINT

#endif



/* ȉ܂͐sĖΉ */

typedef UH						TEXPTN;		/**< %jp{^XNOṽp^[()}%en{Bit pattern for the task exception code(unsigned integer)} */
typedef UH						FLGPTN;		/**< %jp{tOp^[()}%en{Bit pattern of eventflag(unsigned integer)} */

/** %jp{tOp^[()}%en{Message header for a mailbox} */
typedef struct t_msg
{
	struct t_msg	*pk_next;
} T_MSG;

typedef struct t_msg_pri
{
	T_MSG			msgque;
	PRI 			msgpri;
} T_MSG_PRI;


typedef UINT					RDVPTN;
typedef INT						RDVNO;
typedef INT						OVRTIM;

typedef INT						INHNO;		/**< %jp{݃nhԍ}%en{} */
typedef INT						INTNO;		/**< %jp{ݔԍ}%en{} */

typedef INT						EXCNO;		/**< %jp{CPUOnhԍ}%en{} */



/* ------------------------------------ */
/*         macro definition             */
/* ------------------------------------ */

/* %jp{G[R[hE}N} */
#define	ERCD(mercd, sercd)		(((mercd) & 0xff) | ((sercd) << 8))		/**< %jp{G[R[h烁CG[R[ho} */
#define	MERCD(ercd)				((ER)((B)(ercd)))						/**< %jp{G[R[h烁CG[R[ho} */
#define	SERCD(ercd)				((ercd) >> 8)							/**< %jp{G[R[hTuG[R[ho} */



#endif /* _KERNEL__itron_h__ */


/* end of file */

