/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  rdq.h
 * @brief %jp{fB[L[IuWFNg̃wb_t@C}%en{ready-queue object heder file}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef __HOS_V4a__knl_rdq_h__
#define __HOS_V4a__knl_rdq_h__


#if _KERNEL_RDQ_ALGORITHM == _KERNEL_RDQ_ALG_SINGLE_QUE


/* ------------------------------------------ */
/*             single queue                   */
/* ------------------------------------------ */


/** %en{ready-queue control block}%jp{fB[L[ǗubN} */
typedef struct _kernel_t_rdqcb
{
	_KERNEL_T_QUE	que;
} _KERNEL_T_RDQCB;


#define _KERNEL_CRE_RDQ(rdqcb)			_KERNEL_CRE_QUE(&(rdqcb)->que)				/**< %en{create ready-queue}%jp{fB[L[̐} */
#define _KERNEL_DEL_RDQ(rdqcb)			_KERNEL_DEL_QUE(&(rdqcb)->que)				/**< %en{delete ready-queue}%jp{fB[L[̍폜} */

#define _KERNEL_ADD_RDQ(rdqcb, tskhdl)	_KERNEL_ADP_QUE(&(rdqcb)->que, (tskhdl))	/**< %jp{^XNfB[L[ɒǉ} */
#define _KERNEL_RMV_RDQ(rdqcb, tskhdl)	_KERNEL_RMV_QUE(&(rdqcb)->que, (tskhdl))	/**< %jp{^XNfB[O} */

#define _KERNEL_RMH_RDQ(rdqcb)			_KERNEL_RMH_QUE(&(rdqcb)->que)				/**< %jp{L[̐擪^XN̎O} */
#define _KERNEL_REF_RDQ(rdqcb)			_KERNEL_REF_QUE(&(rdqcb)->que)				/**< %jp{L[̐擪^XN̎Q} */

#define _KERNEL_ROT_RDQ(rdqcb, tskpri)	_KERNEL_RTP_QUE(&(rdqcb)->que, (tskpri))	/**< %jp{fB[L[̉]} */


#elif _KERNEL_RDQ_ALGORITHM == _KERNEL_RDQ_ALG_ARRAYED_QUE

/* ------------------------------------------ */
/*               arrayed que                  */
/* ------------------------------------------ */

/** %en{ready-queue control block}%jp{fB[L[ǗubN} */
typedef struct _kernel_t_rdqcb
{
	_KERNEL_T_QUE	que[_KERNEL_TSK_TMAX_TPRI];
} _KERNEL_T_RDQCB;


#define _KERNEL_CRE_RDQ(rdqcb)			_kernel_cre_rdq((rdqcb))					/**< %jp{fB[L[̐}%en{create ready-queue} */
#define _KERNEL_DEL_RDQ(rdqcb)			_kernel_del_rdq((rdqcb))					/**< %jp{fB[L[̍폜}%en{delete ready-queue} */

#define _KERNEL_ADD_RDQ(rdqcb, tskhdl)	_kernel_add_rdq((rdqcb), (tskhdl))			/**< %jp{^XNfB[L[ɒǉ} */
#define _KERNEL_RMV_RDQ(rdqcb, tskhdl)	_kernel_rmv_rdq((rdqcb), (tskhdl))			/**< %jp{^XNfB[O} */

#define _KERNEL_RMH_RDQ(rdqcb)			_kernel_rmh_rdq((rdqcb))					/**< %jp{L[̐擪^XN̎O} */
#define _KERNEL_REF_RDQ(rdqcb)			_kernel_ref_rdq((rdqcb))					/**< %jp{L[̐擪^XN̎Q} */

#define _KERNEL_ROT_RDQ(rdqcb, tskpri)	_kernel_rot_rdq((rdqcb), (tskpri))			/**< %jp{fB[L[̉]} */


#ifdef __cplusplus
extern "C" {
#endif

void             _kernel_cre_rdq(_KERNEL_T_RDQCB *rdqcb);							/**< %jp{fB[L[̐}%en{create ready-queue} */
void             _kernel_del_rdq(_KERNEL_T_RDQCB *rdqcb);							/**< %jp{fB[L[̍폜}%en{delete ready-queue} */

void             _kernel_add_rdq(_KERNEL_T_RDQCB *rdqcb, _KERNEL_T_TSKHDL tskhdl);	/**< %jp{^XNfB[L[ɒǉ} */
void             _kernel_rmv_rdq(_KERNEL_T_RDQCB *rdqcb, _KERNEL_T_TSKHDL tskhdl);	/**< %jp{^XNfB[L[O} */

_KERNEL_T_TSKHDL _kernel_rmh_rdq(_KERNEL_T_RDQCB *rdqcb);							/**< %jp{fB[L[̐擪^XN̎O} */
_KERNEL_T_TSKHDL _kernel_ref_rdq(_KERNEL_T_RDQCB *rdqcb);							/**< %jp{fB[L[̐擪^XN̎Q} */

void             _kernel_rot_rdq(_KERNEL_T_RDQCB *rdqcb, PRI tskpri);				/**< %jp{fB[L[̉]} */

#ifdef __cplusplus
}
#endif



#else	/* error */

#error Illegal value : _KERNEL_QUE_ALGORITHM

#endif



#endif	/* __HOS_V4a__knl_que_h__ */



/* end of file */
