/**
 *  Hyper Operating System V4 Advance
 *
 * @file  dsp.h
 * @brief %jp{^XNfBXpb`̃wb_t@C}%en{task dispatcher heder file}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef _KERNEL_core__dsp_h__
#define _KERNEL_core__dsp_h__



#ifdef __cplusplus
extern "C" {
#endif

void _kernel_dsp_tsk(void);								/**< %jp{^XNfBXpb`} */
void _kernel_ent_tsk(VP_INT exinf1, VP_INT exinf2);		/**< %jp{^XNGg[|Cg} */

void _kernel_dsp_sta_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{^XNJn} */
void _kernel_dsp_ext_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{^XNI} */
void _kernel_dsp_ter_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{^XNI} */
void _kernel_dsp_wai_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{^XN҂Ԃɂ} */
void _kernel_dsp_wup_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{^XN҂} */
void _kernel_dsp_sus_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{^XNTXyh} */
void _kernel_dsp_rsm_tsk(_KERNEL_T_TSKHDL tskhdl);		/**< %jp{^XNTXyh} */

#ifdef __cplusplus
}
#endif


#define _KERNEL_DSP_TSK()				_kernel_dsp_tsk()				/**< %jp{^XNXPW[s} */


#if _KERNEL_SPT_SUS_TSK	/*  %jp{TXyh̃f̏ꍇ} */

#define _KERNEL_DSP_STA_TSK(tskhdl)		_kernel_dsp_sta_tsk(tskhdl)		/**< %jp{^XNJn} */
#define _KERNEL_DSP_EXT_TSK(tskhdl)		_kernel_dsp_ext_tsk(tskhdl)		/**< %jp{^XNI} */
#define _KERNEL_DSP_TER_TSK(tskhdl)		_kernel_dsp_ter_tsk(tskhdl)		/**< %jp{^XNI} */
#define _KERNEL_DSP_WAI_TSK(tskhdl)		_kernel_dsp_wai_tsk(tskhdl)		/**< %jp{^XN҂Ԃɂ} */
#define _KERNEL_DSP_WUP_TSK(tskhdl)		_kernel_dsp_wup_tsk(tskhdl)		/**< %jp{^XN҂} */
#define _KERNEL_DSP_SUS_TSK(tskhdl)		_kernel_dsp_sus_tsk(tskhdl)		/**< %jp{^XNTXyh} */
#define _KERNEL_DSP_RSM_TSK(tskhdl)		_kernel_dsp_rsm_tsk(tskhdl)		/**< %jp{^XNTXyh} */


#else /* %jp{TXyh̃f̏ꍇ} */

#if _KERNEL_RUNTSK_ON_RDQ	/* %jp{sfB[L[Ɍqꍇ} */

#define _KERNEL_DSP_STA_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_RDY); _KERNEL_ADD_RDQ(tskhdl); } while (0)		/**< %jp{^XNJn} */
#define _KERNEL_DSP_EXT_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_DMT); _KERNEL_RMV_RDQ(tskhdl); } while (0)		/**< %jp{^XNI} */
#define _KERNEL_DSP_TER_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_DMT); _KERNEL_RMV_RDQ(tskhdl); } while (0)		/**< %jp{^XNI} */
#define _KERNEL_DSP_WAI_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_WAI); _KERNEL_RMV_RDQ(tskhdl); } while (0)		/**< %jp{^XN҂Ԃɂ} */
#define _KERNEL_DSP_WUP_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_RDY); _KERNEL_ADD_RDQ(tskhdl); } while (0)		/**< %jp{^XN҂} */

#else /* %jp{s̓fB[L[Oꍇ} */

#define _KERNEL_DSP_STA_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_RDY); _KERNEL_ADD_RDQ(tskhdl); } while (0)		/**< ^XNJn */
#define _KERNEL_DSP_EXT_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_DMT);                          } while (0)		/**< ^XNI */
#define _KERNEL_DSP_TER_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_DMT); _KERNEL_RMV_RDQ(tskhdl); } while (0)		/**< ^XNI */
#define _KERNEL_DSP_WAI_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_WAI);                          } while (0)		/**< ^XN҂Ԃɂ */
#define _KERNEL_DSP_WUP_TSK(tskhdl)		do { _KERNEL_TSK_SET_TSKSTAT(_KERNEL_TSK_TSKHDL2TCB(tskhdl), _KERNEL_TTS_RDY); _KERNEL_ADD_RDQ(tskhdl); } while (0)		/**< ^XN҂ */

#endif

#endif



#endif	/* _KERNEL_core__dsp_h__ */



/* end of file */
