/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  cfgsys.h
 * @brief %jp{ITRONVXẽRtBM[Vpwb_t@C}%en{ITRON system configuration heder file}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


/*
%jp{
  {t@CɂāAITRONVXẽRtBM[VsB
  RtBM[V̌ʂɂA{^ȂǃAvP[V
p`ωׁA{t@C̕ύX̓J[l݂̂Ȃ炸A
itron.h  kernel.h 𗘗pĂAAvP[V܂߂
VXeŜrhKvB
  ܂A{t@C̓ZȗOɂgz肵Ă̂ŁA
C\(ႦtypedefȂ)͂̒ɂ͋LڂA}N`Ȃǂ
vvZbTfBNeBû݂Lڂ鎖ƂB
}
*/



#ifndef _KERNEL__config__cfgsys_h__
#define _KERNEL__config__cfgsys_h__


/* %jp{̃ACTCY}%jp{Memory alignment size} */
#define _KERNEL_CFG_MEM_ALIGN			(-1)				/**< ̃ACTCY(-1̎ftHgl)}%en{Memory alignment size (-1:default)} */


/* %jp{ITRONdlʃf[^^}%en{ITRON General Data Type} */
#define _KERNEL_CFG_TBIT_INT			(-1)				/**< %jp{INT     ̃rbg (-1̎ftHgl)}%en{Number of bits in INT     (-1:default)} */
#define _KERNEL_CFG_TBIT_UINT			(-1)				/**< %jp{UINT    ̃rbg (-1̎ftHgl)}%en{Number of bits in UINT    (-1:default)} */
#define _KERNEL_CFG_TBIT_BOOL			(-1)				/**< %jp{BOOL    ̃rbg (-1̎ftHgl)}%en{Number of bits in BOOL    (-1:default)} */
#define _KERNEL_CFG_TBIT_FN				(-1)				/**< %jp{FN      ̃rbg (-1̎ftHgl)}%en{Number of bits in FN      (-1:default)} */
#define _KERNEL_CFG_TBIT_ER				(-1)				/**< %jp{ER      ̃rbg (-1̎ftHgl)}%en{Number of bits in ER      (-1:default)} */
#define _KERNEL_CFG_TBIT_ID				(-1)				/**< %jp{ID      ̃rbg (-1̎ftHgl)}%en{Number of bits in ID      (-1:default)} */
#define _KERNEL_CFG_TBIT_ATR			(-1)				/**< %jp{ATR     ̃rbg (-1̎ftHgl)}%en{Number of bits in ATR     (-1:default)} */
#define _KERNEL_CFG_TBIT_STAT			(-1)				/**< %jp{STAT    ̃rbg (-1̎ftHgl)}%en{Number of bits in STAT    (-1:default)} */
#define _KERNEL_CFG_TBIT_MODE			(-1)				/**< %jp{MODE    ̃rbg (-1̎ftHgl)}%en{Number of bits in MODE    (-1:default)} */
#define _KERNEL_CFG_TBIT_PRI			(-1)				/**< %jp{PRI     ̃rbg (-1̎ftHgl)}%en{Number of bits in PRI     (-1:default)} */
#define _KERNEL_CFG_TBIT_SIZE			(-1)				/**< %jp{SIZE    ̃rbg (-1̎ftHgl)}%en{Number of bits in SIZE    (-1:default)} */
#define _KERNEL_CFG_TBIT_TMO			(-1)				/**< %jp{TMO     ̃rbg (-1̎ftHgl)}%en{Number of bits in TMO     (-1:default)} */
#define _KERNEL_CFG_TBIT_RELTIM			(-1)				/**< %jp{RELTIM  ̃rbg (-1̎ftHgl)}%en{Number of bits in RELTIM  (-1:default)} */
#define _KERNEL_CFG_SYSTIM_STRUCT		FALSE				/**< %jp{SYSTIM^\̂ɂ邩ǂ} */
#define _KERNEL_CFG_TBIT_SYSTIM			32					/**< %jp{SYSTIM^̃rbg} */
#define _KERNEL_CFG_VP_INT_PTR			FALSE				/**< %jp{VP_INT^|C^^ɂ邩ǂ} */
#define _KERNEL_CFG_TBIT_VP_INT			(-1)				/**< %jp{VP_INT  ̃rbg (-1̎ftHgl)}%en{Number of bits in VP_INT  (-1:default)} */
#define _KERNEL_CFG_TBIT_ER_BOOL		(-1)				/**< %jp{ER_BOOL ̃rbg (-1̎ftHgl)}%en{Number of bits in ER_BOOL (-1:default)} */
#define _KERNEL_CFG_TBIT_ER_ID			(-1)				/**< %jp{ER_ID   ̃rbg (-1̎ftHgl)}%en{Number of bits in ER_ID   (-1:default)} */
#define _KERNEL_CFG_TBIT_ER_UINT		(-1)				/**< %jp{ER_UINT ̃rbg (-1̎ftHgl)}%en{Number of bits in ER_UINT (-1:default)} */

/* %jp{J[l̃f[^^}%en{Kernel Data Type} */
#define _KERNEL_CFG_TBIT_TEXPTN			(-1)				/**< %jp{^XNOṽrbg(-1̎ftHgl)} */
#define _KERNEL_CFG_TBIT_FLGPTN			(-1)				/**< %jp{CxgtÕrbg(-1̎ftHgl)} */
#define _KERNEL_CFG_TBIT_RDVPTN			(-1)				/**< %jp{fũrbg(-1̎ftHgl)} */
#define _KERNEL_CFG_TBIT_RDVNO			(-1)
#define _KERNEL_CFG_TBIT_OVRTIM			(-1)
#define _KERNEL_CFG_TBIT_INHNO			(-1)
#define _KERNEL_CFG_TBIT_INTNO			(-1)
#define _KERNEL_CFG_TBIT_EXCNO			(-1)


/* %jp{Dx͈̔}%en{Priority Range} */
#define _KERNEL_CFG_TMAX_TPRI			127					/**< %jp{^XNDx̍ől(-1̎ftHgl)}%en{Maximum task priority} */
#define _KERNEL_CFG_TMAX_MPRI			127					/**< %jp{bZ[WDx̍ől(-1̎ftHgl)}%en{Maximum message priority} */

/* %jp{L[CO^lXg񐔂̍ől}%en{Maximum Nesting/Queueing Count} */
#define _KERNEL_CFG_TMAX_ACTCNT			127					/**< %jp{^XNNvL[CO̍ől(-1̎ftHgl)} */
#define _KERNEL_CFG_TMAX_WUPCNT			127					/**< %jp{^XNNvL[CO̍ől(-1̎ftHgl)} */
#define _KERNEL_CFG_TMAX_SUSCNT			127					/**< %jp{^XN҂vlXg̍ől(-1̎ftHgl)} */

/* %jp{rbgp^[̃rbg} %en{Number of Bits in Bitpatterns}*/
#define _KERNEL_CFG_TEX_TBIT_TEXPTN		(-1)				/**< %jp{^XNOṽrbg(-1̎ftHgl)} */
#define _KERNEL_CFG_FLG_TBIT_FLGPTN		(-1)				/**< %jp{CxgtÕrbg(-1̎ftHgl)} */
#define _KERNEL_CFG_RDV_TBIT_RDVPTN		(-1)				/**< %jp{fũrbg(-1̎ftHgl)} */

/* %jp{Z}tH̍ől}%en{Maximum value of the maximum definable semaphore resource count} */
#define _KERNEL_CFG_TMAX_MAXSEM			(-1)				/**< %jp{Z}tH̍ől}%en{Maximum value of the maximum definable semaphore resource count} */


/* %jp{T_RTSK̕ύX}%en{T_RTSK̕ύX} */
#define _KERNEL_CFG_RTSK_TSKATR			TRUE				/**< %jp{T_RTSK tskatr ܂߂邩(HOSƎg@\)} */
#define _KERNEL_CFG_RTSK_EXINF			TRUE				/**< %jp{T_RTSK exinf ܂߂邩(HOSƎg@\)} */
#define _KERNEL_CFG_RTSK_TASK			TRUE				/**< %jp{T_RTSK task ܂߂邩(HOSƎg@\)} */
#define _KERNEL_CFG_RTSK_ITSKPRI		TRUE				/**< %jp{T_RTSK itskpri ܂߂邩(HOSƎg@\)} */	
#define _KERNEL_CFG_RTSK_STKSZ			TRUE				/**< %jp{T_RTSK stksz ܂߂邩(HOSƎg@\)} */
#define _KERNEL_CFG_RTSK_STK			TRUE				/**< %jp{T_RTSK stk ܂߂邩(HOSƎg@\)} */


/* %jp{T_RTST̍\}%en{T_RTST} */
#define _KERNEL_CFG_RTST_TSKATR			FALSE				/**< %jp{T_RTST tskatr ܂߂邩(HOSƎg@\)} */
#define _KERNEL_CFG_RTST_EXINF			TRUE				/**< %jp{T_RTST exinf ܂߂邩(HOSƎg@\)} */
#define _KERNEL_CFG_RTST_TASK			FALSE				/**< %jp{T_RTST task ܂߂邩(HOSƎg@\)} */
#define _KERNEL_CFG_RTST_ITSKPRI		FALSE				/**< %jp{T_RTST itskpri ܂߂邩(HOSƎg@\)} */	
#define _KERNEL_CFG_RTST_STKSZ			FALSE				/**< %jp{T_RTST stksz ܂߂邩(HOSƎg@\)} */
#define _KERNEL_CFG_RTST_STK			FALSE				/**< %jp{T_RTST stk ܂߂邩(HOSƎg@\)} */



#endif	/* _KERNEL__config__cfgsys_h__ */



/* end of file */
