/**
 *  Hyper Operating System V4 Advance
 *
 * @file  proc.h
 * @brief %jp{vZbTA[LeN`ŗL@\}%en{Processor archtecture}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__win32__proc_h__
#define _KERNEL__win32__proc_h__


/** %jp{Windows wb_t@C̓ǂ݂} */
#define SIZE	WIN_SIZE
#define BOOL	WIN_BOOL
#include <windows.h>
#include <tchar.h>
#undef	SIZE
#undef	BOOL

#include <setjmp.h>



/** %jp{ReLXgۑubN} */
typedef struct _kernel_t_ctxcb
{
	FP					entry;				/**< %jp{Gg[AhX} */
	VP_INT				exinf1;				/**< %jp{p[^P} */
	VP_INT				exinf2;				/**< %jp{p[^Q} */
	jmp_buf				jmpenv;				/**< %jp{ReLXgZbgplongjmpf[^} */

	BOOL				blInterrupt;		/**< %jp{ݏtO} */
	HANDLE				hEvent;				/**< %jp{Cxgnh} */
	HANDLE				hThread;			/**< %jp{Xbhnh} */
	DWORD				dwThreadId;			/**< %jp{XbhID} */
	HANDLE				hIntEvent;			/**< %jp{Cxgnh} */
	HANDLE				hIntThread;			/**< %jp{Xbhnh} */
	DWORD				dwIntThreadId;		/**< %jp{XbhID} */
} _KERNEL_T_CTXCB;


/** %jp{݃ReLXgubN} */
typedef struct _kernel_t_ictxcb
{
	_KERNEL_T_CTXCB		*runctxcb;			/**< %jp{s̃ReLXg} */
	INHNO				inhno;

	CRITICAL_SECTION	CriticalSection;	/**< %jp{NeBJZNV} */
	HANDLE				hSemIntLock;		/**< %jp{VXe̔rpZ}tH} */
	volatile BOOL		blIntCtx;			/**< %jp{ݏtO} */
	volatile BOOL		blDisInt;			/**< %jp{݋֎~tO} */
	DWORD				dwPrimaryThreadId;	/**< %jp{vC}XbhID} */
} _KERNEL_T_ICTXCB;


extern _KERNEL_T_ICTXCB _kernel_ictxcb;		/**< %jp{݃ReLXgubN} */



#ifdef __cplusplus
extern "C" {
#endif

void    _kernel_ini_prc(void);																/**< %jp{A[LeN`ŗL̏} */

void    _kernel_ena_int(void);																/**< %jp{݋} */
void    _kernel_dis_int(void);																/**< %jp{݋֎~} */
void    _kernel_wai_int(void);																/**< %jp{ݑ҂(ACh̏)} */

void    _kernel_cre_ctx(_KERNEL_T_CTXCB *ctxcb, FP entry, VP_INT exinf1, VP_INT exinf2);	/**< %jp{sReLXg̍쐬} */
void    _kernel_del_ctx(_KERNEL_T_CTXCB *ctxcb);											/**< %jp{sReLXg̍폜} */
void    _kernel_rst_ctx(_KERNEL_T_CTXCB *ctxcb);											/**< %jp{sReLXg̃X^[g} */
void    _kernel_sta_ctx(_KERNEL_T_CTXCB *ctxcb);											/**< %jp{sReLXg̊Jn} */
void    _kernel_swi_ctx(_KERNEL_T_CTXCB *ctxcb_now, _KERNEL_T_CTXCB *ctxinf_nxt);			/**< %jp{sReLXg̐ؑ} */

void     vsig_int(int inhno);																/**< %jp{[݃T|[gAPI} */

#ifdef __cplusplus
}
#endif


#define _KERNEL_INI_PRC()				_kernel_ini_prc()

#define _KERNEL_INI_INT(stksz, stk)		do {} while(0)
#define _KERNEL_ENA_INT()				_kernel_ena_int()									/**< %jp{݋} */
#define _KERNEL_DIS_INT()				_kernel_dis_int()									/**< %jp{݋֎~} */
#define _KERNEL_WAI_INT()				_kernel_wai_int()									/**< %jp{ݑ҂(ACh̏)} */


#define _KERNEL_CRE_CTX(ctxcb, stksz, stk, isp, entry, par1, par2)		\
							_kernel_cre_ctx(ctxcb, entry, par1, par2)
#define _KERNEL_DEL_CTX(ctxcb)	_kernel_del_ctx(ctxcb)
#define _KERNEL_RST_CTX(ctxcb, stksz, stk, isp, entry, par1, par2)		\
							_kernel_rst_ctx(ctxcb)
#define _KERNEL_STA_CTX(ctxcb)	_kernel_sta_ctx(ctxcb)
#define _KERNEL_SWI_CTX(ctxcb_now, ctxcb_nxt)							\
							_kernel_swi_ctx(ctxcb_now, ctxcb_nxt)



#endif	/* _KERNEL__win32__proc_h__ */


/* end of file */
