/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  procatr.h
 * @brief %jp{vZbTA[LeN`ŗL@\}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__arch__proc__mn1030__procatr_h__
#define _KERNEL__arch__proc__mn1030__procatr_h__


/* %jp{vZbTA[LeN``̂CN[hpX} */
#define _KERNEL_PROCATR_INC_PATH			"mn103/mn1030"


/* %jp{vZbTA[LeN`Ɉˑ} */
#define _KERNEL_PROCATR_CTX_STK				FALSE		/**< %jp{ReLXgɃX^bN̈̎w肪KvH} */
#define _KERNEL_PROCATR_CTX_STKSZ			FALSE		/**< %jp{ReLXgɃX^bNTCY̎w肪KvH} */
#define _KERNEL_PROCATR_CTX_ISP				TRUE		/**< %jp{ReLXgɏX^bN|C^lKvH} */
#define _KERNEL_PROCATR_CTX_DEL				FALSE		/**< %jp{ʃReLXg̃ReLXg폜KvH} */
#define _KERNEL_PROCATR_CTX_RST				TRUE		/**< %jp{ReLXg̃X^[g\H} */

#define _KERNEL_PROCATR_TMIN_STKSZ			(4*16)		/**< %jp{ŒKvȃX^bNTCY(byteP)} */

#define _KERNEL_PROCATR_SPT_SMP				FALSE		/**< %jp{SMPɑΉĂ邩H} */
#define _KERNEL_PROCATR_SPT_MULTINT			TRUE		/**< %jp{d݂ɑΉĂ邩H} */

#define _KERNEL_PROCATR_TMIN_INHNO			0			/**< %jp{݃nhԍ̍ŏl} */
#define _KERNEL_PROCATR_TMAX_INHNO			1			/**< %jp{݃nhԍ̍ől} */

#define _KERNEL_PROCATR_TMIN_EXCNO			0			/**< %jp{CPUOnhԍ̍ŏl} */
#define _KERNEL_PROCATR_TMAX_EXCNO			4			/**< %jp{CPUOnhԍ̍ől} */

#define _KERNEL_PROCATR_SYSSTK_NUM			2			/**< %jp{VXeX^bN͉{KvH} */

#define _KERNEL_PROCATR_SIGNED_INT			0			/**< %jp{tƕ̂ǂ炪ӂH(t:1, :-1, :0)} */
#define _KERNEL_PROCATR_TBIT_INT			32			/**< %jp{vZbTɍœKȐ^̃rbg} */
#define _KERNEL_PROCATR_TBIT_PTR			32			/**< %jp{|C^̃rbg} */
#define _KERNEL_PROCATR_MEM_ALIGN			8			/**< %jp{K؂ȃ̃ACg(byteP)} */
#define _KERNEL_PROCATR_STK_ALIGN			8			/**< %jp{K؂ȃX^bÑACg(byteP)} */
#define _KERNEL_PROCATR_ALLOW_UNALIGN		FALSE		/**< %jp{AACANZX͉\H} */


/* %jp{ARMŗL̒萔} */
#define _KERNEL_ARM_INHNO_IRQ				0			/**< %jp{IRQ݂̊݃nhԍ} */
#define _KERNEL_ARM_INHNO_FIQ				1			/**< %jp{FIQ݂̊݃nhԍ} */

#define _KERNEL_ARM_EXCNO_RST				0			/**< %jp{ZbgCPUOnhԍ} */
#define _KERNEL_ARM_EXCNO_UND				1			/**< %jp{ߗOCPUOnhԍ} */
#define _KERNEL_ARM_EXCNO_SWI				2			/**< %jp{\tgEFA݂CPUOnhԍ} */
#define _KERNEL_ARM_EXCNO_PRE				3			/**< %jp{vtFb`A{[gCPUOnhԍ} */
#define _KERNEL_ARM_EXCNO_ABT				4			/**< %jp{f[^A{[gCPUOnhԍ} */

#define _KERNEL_PROCATR_SYS_CTX				FALSE		/**< %jp{ReLXgԊǗvZbTŎ{邩H} */
#define _KERNEL_PROCATR_SYS_LOC				FALSE		/**< %jp{CPUbNԊǗvZbTŎ{邩H} */
#define _KERNEL_PROCATR_SYS_DSP				FALSE		/**< %jp{fBXpb`֎~ԊǗvZbTŎ{邩H} */
#define _KERNEL_PROCATR_SYS_SYS				FALSE		/**< %jp{VXeԊǗvZbTŎ{邩H} */
#define _KERNEL_PROCATR_SYS_DLY				FALSE		/**< %jp{xfBXpb`ۗԊǗvZbTŎ{邩H} */



#endif	/* _KERNEL__arch__proc__mn1030__procatr_h__ */


/* end of file */
