/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  ctxctl.h
 * @brief %jp{ReLXg}%en{context control}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__arch__proc__h8__h8300ha__proc_h__
#define _KERNEL__arch__proc__h8__h8300ha__proc_h__


#define _KERNEL_IMSK_I		0x80		/**< %jp{݃}XNrbg} */
#define _KERNEL_IMSK_UI		0x40		/**< %jp{[U[rbg^݃}XNrbg} */

#define _KERNEL_IMSK_LV0	0xc0		/**< %jp{݃}XNx0(ׂă}XN)} */
#define _KERNEL_IMSK_LV1	0x80		/**< %jp{݃}XNx1(D抄݂̂݋)} */
#define _KERNEL_IMSK_LV2	0x00		/**< %jp{݃}XNx2(ׂċ)} */


/** %jp{ReLXgۑubN} */
typedef struct _kernel_t_ctxcb
{
	VP	sp;								/**< %jp{X^bN|C^}%en{Stack pointer} */
} _KERNEL_T_CTXCB;


/** %jp{݃ReLXgۑubN} */
typedef struct _kernel_t_ictxcb
{
	UB	imsk;							/**< %jp{݃}XN}%en{Interrupt mask} */
	UB	intcnt;							/**< %jp{݃lXgJE^}%en{Interrupt nest counter} */
	VP	isp;							/**< %jp{ݏX^bN|C^}%en{Initial stack pointer for interrupt} */
} _KERNEL_T_ICTXCB;



/* %jp{Lϐ`} */
extern _KERNEL_T_ICTXCB _kernel_ictxcb;	/**< %jp{݃ReLXgۑubN} */


#ifdef __cplusplus
extern "C" {
#endif

void    _kernel_ena_int(void);																		/**< %jp{݋} */
void    _kernel_dis_int(void);																		/**< %jp{݋֎~} */
void    _kernel_wai_int(void);																		/**< %jp{ݑ҂(ACh̏)} */

void    _kernel_cre_ctx(_KERNEL_T_CTXCB *pk_ctxcb, VP isp, FP entry, VP_INT par1, VP_INT par2);		/**< %jp{sReLXg̍쐬} */
void    _kernel_del_ctx(_KERNEL_T_CTXCB *pk_ctxcb);													/**< %jp{sReLXg̍폜} */
void    _kernel_rst_ctx(VP_INT par1, VP_INT par2, FP entry, VP isp);								/**< %jp{sReLXg̃X^[g} */
void    _kernel_sta_ctx(_KERNEL_T_CTXCB *pk_ctxcb);													/**< %jp{sReLXg̊Jn} */
void    _kernel_swi_ctx(_KERNEL_T_CTXCB *pk_ctxinf_nxt, _KERNEL_T_CTXCB *pk_ctxcb_now);				/**< %jp{sReLXg̐ؑ} */

#ifdef __cplusplus
}
#endif


#define _KERNEL_INI_PRC()	do {} while (0)

#define _KERNEL_INI_INT(stksz, stk)	do { _kernel_ictxcb.isp = (VB *)(stk) + (stksz); } while (0)
#define _KERNEL_ENA_INT()			_kernel_ena_int()												/**< %jp{݋} */
#define _KERNEL_DIS_INT()			_kernel_dis_int()												/**< %jp{݋֎~} */
#define _KERNEL_WAI_INT()			_kernel_wai_int()												/**< %jp{ݑ҂(ACh̏)} */

#define _KERNEL_CRE_CTX(pk_ctxcb, stksz, stk, isp, entry, exinf1, exinf2)		\
									_kernel_cre_ctx((pk_ctxcb), (isp), (entry), (exinf1), (exinf2))
#define _KERNEL_DEL_CTX(pk_ctxcb)	_kernel_del_ctx(pk_ctxcb)
#define _KERNEL_RST_CTX(pk_ctxcb, stksz, stk, isp, entry, exinf1, exinf2)		\
									_kernel_rst_ctx((exinf1), (exinf2), (entry), (isp))
#define _KERNEL_STA_CTX(pk_ctxcb)	_kernel_sta_ctx(pk_ctxcb)
#define _KERNEL_SWI_CTX(pk_ctxcb_now, pk_ctxinf_nxt)							\
									_kernel_swi_ctx((pk_ctxinf_nxt), (pk_ctxcb_now))


#endif	/* _KERNEL__arch__proc__h8__h8300ha__proc_h__ */


/* end of file */
