/**
 *  Hyper Operating System V4 Advance
 *
 * @file  procatr.h
 * @brief %jp{ARMv7-M}%en{ARMv7-M}
 *
 * Copyright (C) 1998-2011 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__arch__proc__arm__arm_v7m__procatr_h__
#define _KERNEL__arch__proc__arm__arm_v7m__procatr_h__


#define _KERNEL_PROCATR_ARM_ARMV7M


/* %jp{vZbTA[LeN``̂CN[hpX} */
#define _KERNEL_PROCATR_INC_PATH			"arm/arm_v7m"


/* %jp{vZbTA[LeN`Ɉˑ} */
#define _KERNEL_PROCATR_CTX_STK				FALSE		/**< %jp{ReLXgɃX^bN̈̎w肪KvH} */
#define _KERNEL_PROCATR_CTX_STKSZ			FALSE		/**< %jp{ReLXgɃX^bNTCY̎w肪KvH} */
#define _KERNEL_PROCATR_CTX_ISP				TRUE		/**< %jp{ReLXgɏX^bN|C^lKvH} */
#define _KERNEL_PROCATR_CTX_DEL				FALSE		/**< %jp{ʃReLXg̃ReLXg폜KvH} */
#define _KERNEL_PROCATR_CTX_RST				TRUE		/**< %jp{ReLXg̃X^[g\H} */

#define _KERNEL_PROCATR_TMIN_STKSZ			(4*16)		/**< %jp{ŒKvȃX^bNTCY(byteP)} */
#define _KERNEL_PROCATR_DEF_SYSSTKSZ		64
#define _KERNEL_PROCATR_DEF_INTSTKSZ		256

#define _KERNEL_PROCATR_SPT_SMP				FALSE		/**< %jp{SMPɑΉĂ邩H} */
#define _KERNEL_PROCATR_SPT_MULTINT			TRUE		/**< %jp{d݂ɑΉĂ邩H} */

#define _KERNEL_PROCATR_TMIN_INHNO			0			/**< %jp{݃nhԍ̍ŏl} */
#define _KERNEL_PROCATR_TMAX_INHNO			255			/**< %jp{݃nhԍ̍ől} */

#define _KERNEL_PROCATR_TMIN_EXCNO			0			/**< %jp{CPUOnhԍ̍ŏl} */
#define _KERNEL_PROCATR_TMAX_EXCNO			15			/**< %jp{CPUOnhԍ̍ől} */

#define _KERNEL_PROCATR_SYSSTK_NUM			1			/**< %jp{VXeX^bN͉{KvH} */

#define _KERNEL_PROCATR_SIGNED_INT			0			/**< %jp{tƕ̂ǂ炪ӂH(t:1, :-1, :0)} */
#define _KERNEL_PROCATR_TBIT_INT			32			/**< %jp{vZbTɍœKȐ^̃rbg} */
#define _KERNEL_PROCATR_TBIT_PTR			32			/**< %jp{|C^̃rbg} */
#define _KERNEL_PROCATR_MEM_ALIGN			4			/**< %jp{K؂ȃ̃ACg(byteP)} */
#define _KERNEL_PROCATR_STK_ALIGN			8			/**< %jp{K؂ȃX^bÑACg(byteP)} */
#define _KERNEL_PROCATR_ALLOW_UNALIGN		FALSE		/**< %jp{AACANZX͉\H} */

#define _KERNEL_PROCATR_SYS_CTX				TRUE		/**< %jp{ReLXgԊǗvZbTŎ{邩H} */
#define _KERNEL_PROCATR_SYS_LOC				FALSE		/**< %jp{CPUbNԊǗvZbTŎ{邩H} */
#define _KERNEL_PROCATR_SYS_DSP				FALSE		/**< %jp{fBXpb`֎~ԊǗvZbTŎ{邩H} */
#define _KERNEL_PROCATR_SYS_SYS				FALSE		/**< %jp{VXeԊǗvZbTŎ{邩H} */
#define _KERNEL_PROCATR_SYS_DLY				TRUE		/**< %jp{xfBXpb`ۗԊǗvZbTŎ{邩H} */



#endif	/* _KERNEL__arch__proc__arm__arm_v7m__procatr_h__ */


/* end of file */
