# ----------------------------------------------------------------------------
#  Hyper Operating System V4 Advance
#
#  Copyright (C) 1998-2006 by Project HOS
#  http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------



# --------------------------------------
#  %jp{IvVWJ}%en{options}
# --------------------------------------


# %jp{CCN[hpXIvV̒`}%en{C-compiler include path}
ifneq ($(INC_DIRS),)
CFLAGS_INC ?= $(patsubst %,-I%,$(INC_DIRS))
endif


# %jp{C}N`IvV̒`}%en{C-compiler define macros}
ifneq ($(C_DEFS),)
CFLAGS_DEF ?= $(patsubst %,-D%,$(C_DEFS))
endif


# %jp{AZuCN[hpXIvV̒`}%en{Assembler include path}
ifneq ($(INC_DIRS),)
AFLAGS_INC ?= $(patsubst %,-I%,$(INC_DIRS))
endif


# %jp{AZu}N`IvV̒`}%en{Assembler define macros}
ifneq ($(A_DEFS),)
AFLAGS_DEF ?= $(patsubst %,-D%,$(A_DEFS))
endif


# %jp{IvV}{Options marged}
CFLAGS += $(CFLAGS_INC) $(CFLAGS_DEF)
AFLAGS += $(AFLAGS_INC) $(AFLAGS_DEF)



# --------------------------------------
#  %jp[`}%en{Rules}
# --------------------------------------


# %jp{st@C}%en{Executable file}
$(TARGET_EXE): $(OBJS) $(LIBS)
	$(CMD_LINK) $(LNFLAGS) $(OBJS) $(LIBS) $(LNFLAGS2) -o $(TARGET_EXE)


# %jp{g[S`t@C}%en{Motorola S format file}
$(TARGET_MOT): $(TARGET_EXE)
	$(CMD_OBJCNV) -O srec $(TARGET_EXE) $(TARGET_MOT)


# %jp{CeHEX`t@C}%en{Intel HEX format file}
$(TARGET_HEX): $(TARGET_EXE)
	$(CMD_OBJCNV) -O ihex $(TARGET_EXE) $(TARGET_HEX)


# %jp{v[oCi`t@C}%en{Plain Binary}
$(TARGET_BIN): $(TARGET_EXE)
	$(CMD_OBJCNV) -O binary $(TARGET_EXE) $(TARGET_BIN)


# %jp{Cu}%en{Library}
$(TARGET_LIB): $(OBJS)
	$(CMD_LIBR) $(ARFLAGS) -r $(TARGET_LIB) $(OBJS)


# %jp{CRpC}%en{C Compile}
$(OBJS_DIR)/%.$(EXT_OBJ) :: %.$(EXT_C)
	$(CMD_CC) $(CFLAGS) -c $< -o $@


# %jp{AZu}%en{Assemble}
$(OBJS_DIR)/%.$(EXT_OBJ) :: %.$(EXT_ASM)
	$(CMD_ASM) $(AFLAGS) -c $< -o $@


# %jp{ꊇRpC}%en{batch cmpile}
batch_c:
	$(CMD_CC) $(CFLAGS) -c $(CSRCS)
	$(CMD_MV) -f $(addsuffix .$(EXT_OBJ), $(basename $(notdir $(CSRCS)))) $(OBJS_DIR)


# %jp{ꊇAZu}%en{batch cmpile}
batch_asm:
	$(CMD_CC) $(CFLAGS) -c $(ASRCS)
	$(CMD_MV) -f $(addsuffix .$(EXT_OBJ), $(basename $(notdir $(ASRCS)))) $(OBJS_DIR)



# end of file
