# ----------------------------------------------------------------------------
#  Hyper Operating System V4 Advance
#
#  Copyright (C) 1998-2007 by Project HOS
#  http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------




# --------------------------------------
#  %jp{IvVWJ}%en{options}
# --------------------------------------


# %jp{CCN[hpXIvV̒`}%en{C-compiler include path}
ifneq ($(INC_DIRS),)
CFLAGS_INC = -I=$(subst $(space),$(comma),$(strip $(INC_DIRS)))
endif


# %jp{C}N`IvV̒`}%en{C-compiler define macros}
ifneq ($(C_DEFS),)
CFLAGS_DEF = -DEF=$(subst $(space),$(comma),$(strip $(C_DEFS)))
endif


# %jp{AZuCN[hpXIvV̒`}%en{Assembler include path}
ifneq ($(INC_DIRS),)
AFLAGS_INC = -I=$(subst $(space),$(comma),$(strip $(INC_DIRS)))
endif


# %jp{AZu}N`IvV̒`}%en{Assembler define macros}
ifneq ($(A_DEFS),)
AFLAGS_DEF = -DEF=$(subst $(space),$(comma),$(strip $(A_DEFS)))
endif


# %jp{IvV}{Options marged}
CFLAGS += $(CFLAGS_INC) $(CFLAGS_DEF)
AFLAGS += $(AFLAGS_INC)



# --------------------------------------
#  %jp[`}%en{Rules}
# --------------------------------------

# %jp{st@C}%en{Executable file}
$(TARGET_EXE): $(OBJS) $(LIBS)
	$(CMD_RM) -f $(TARGET_EXE)
	$(CMD_ECHO) "-rom D=R"                                            > $(OBJS_DIR)/linksub.txt
	$(CMD_ECHO) "-list $(TARGET).map"                                >> $(OBJS_DIR)/linksub.txt
	$(CMD_ECHO) "-SHow SY,R,X"                                       >> $(OBJS_DIR)/linksub.txt
	$(CMD_ECHO) "-Input=$(subst $(space),$(comma),$(strip $(OBJS)))" >> $(OBJS_DIR)/linksub.txt
	$(CMD_ECHO) "-LIB=$(subst $(space),$(comma),$(strip $(LIBS)))"   >> $(OBJS_DIR)/linksub.txt
	$(CMD_ECHO) "-start=VECTTBL/$(SECTION_VECT),P,C,C\$$BSEC,C\$$DSEC,D/$(SECTION_RO),B,R,S/$(SECTION_RW)" >> $(OBJS_DIR)/linksub.txt
	$(CMD_ECHO) "-output=$(TARGET_EXE)"                              >> $(OBJS_DIR)/linksub.txt
	$(CMD_LINK) -SU=$(OBJS_DIR)/linksub.txt


# %jp{g[S`t@C}%en{Motorola S format file}
$(TARGET_MOT): $(TARGET_EXE)
	$(CMD_ECHO) "-input=$(TARGET_EXE)"     > $(OBJS_DIR)/ascsub.txt
	$(CMD_ECHO) "-form stype"             >> $(OBJS_DIR)/ascsub.txt
	$(CMD_ECHO) "-output $(TARGET_MOT)"   >> $(OBJS_DIR)/ascsub.txt
	$(CMD_OBJCNV) -SU=$(OBJS_DIR)/ascsub.txt


# %jp{Cu}%en{Library}
$(TARGET_LIB): $(OBJS)
	$(CMD_RM) -f $(TARGET_LIB)
	$(CMD_ECHO) "-Input=$(subst $(space),$(comma),$(strip $(OBJS)))" > $(OBJS_DIR)/subcmd.txt
	$(CMD_ECHO) "-OUtput=$(TARGET_LIB)"                             >> $(OBJS_DIR)/subcmd.txt
	$(CMD_ECHO) "-FOrm=Library"                                     >> $(OBJS_DIR)/subcmd.txt
	$(CMD_LIBR) "-SU=$(OBJS_DIR)/subcmd.txt"


# %jp{CRpC}%en{C Compile}
$(OBJS_DIR)/%.obj :: %.c
	$(CMD_CC) $(CFLAGS) $< -OB=$@ -List=$(@:%.obj=%.lst)


# %jp{AZu}%en{Assemble}
$(OBJS_DIR)/%.obj :: %.src
	$(CMD_ASM) $(AFLAGS) $< -OB=$@



# end of file
