// ---------------------------------------------------------------------------
//  Hyper Operating System V4  RtBM[^[                           
//    f[^ǂݍ݃NX                                                    
//                                                                            
//                                    Copyright (C) 1998-2002 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "defercd.h"
#include "read.h"


// RXgN^
CRead::CRead(FILE *fp, const char *name)
{
	m_fpRead    = fp;
	m_iPhysicalLineNum = m_iLogicalLineNum = 1;
	m_blLineTop = true;
	strncpy(m_szLogicalInputFile, name, READ_MAX_PATH - 1);
	m_szLogicalInputFile[READ_MAX_PATH - 1] = '\0';
}


// fXgN^
CRead::~CRead()
{
}


// PXe[gǂݍ
int CRead::ReadState(char *szState)
{
	bool blEsc   = false;
	bool blSpace = true;	// true Ŏn߂Đ擪̋󔒂ǂݔ΂
	int  iCount = 0;
	int  iErr;
	int  c;

	for ( ; ; )
	{
		// Pǂݍ
		if ( (c = fgetc(m_fpRead)) == EOF )
		{
			if ( blEsc || iCount != 0 )
			{
				iErr = CFG_ERR_EOF;	// \EOF
			}
			else
			{
				iErr = CFG_ERR_COMPLETE;	// 
			}
			break;
		}

		// TCY`FbN
		if ( iCount >= READ_MAX_STATE - 1 )
		{
			iErr = CFG_ERR_STATE_LEN;
			break;
		}

		// s # ȂXLbv
		if ( m_blLineTop && c == '#' )
		{
                       iErr = SkipPreProcessorLine(szState, iCount);
			if ( iErr != CFG_ERR_OK )
			{
				break;
			}
			continue;
		}

		// s̏
		if ( c == '\n' )
		{
			m_iPhysicalLineNum++;
			m_iLogicalLineNum++;
			m_blLineTop = true;
		}
		else
		{
			m_blLineTop = false;
		}

		// 󔒕̃XLbv
		if ( isspace(c) || c == '\n' )
		{
			if ( !blSpace )
			{
				szState[iCount++] = ' ';
				blSpace = true;
			}
			continue;
		}
		blSpace = false;

		// ̏
		if ( c == '\"' || c == '\'' )
		{
			szState[iCount++] = c;
			iErr = ReadString(c, szState, iCount);
			if ( iErr != CFG_ERR_OK )
			{
				break;
			}
			continue;
		}

		// Xe[gȂ
		if ( c == ';' )
		{
			iErr = CFG_ERR_OK;
			break;
		}

		// ̓ǂݍ
		szState[iCount++] = c;
	}

	// ̋󔒕폜
	if ( iCount > 0 && szState[iCount - 1] == ' ' )
	{
		iCount--;
	}

	szState[iCount] = '\0';

	return iErr;
}


// vvZbTC̃XLbv
int CRead::SkipPreProcessorLine(char* szText, int iCountOrg)
{
	int  c;
	int iCount = iCountOrg;
	long tmpLineNum;
	char *p1, *p2;

	for ( ; ; )
	{
		// Pǂݍ
		if ( (c = fgetc(m_fpRead)) == EOF )
		{
			return CFG_ERR_OK;
		}

		// TCY`FbN
		if ( iCount >= READ_MAX_STATE - 1 )
		{
			return CFG_ERR_STATE_LEN;
		}

		// s̃`FbN
		if ( c == '\n' )
		{
			m_iPhysicalLineNum++;
			m_iLogicalLineNum++;

			szText[iCount] = '\0';

			// #line 123 "filename"
			// # 123 "filename"
			// ̌`̂ǂł󂯕t
			if (strncmp(&szText[iCountOrg], "line", 4) == 0)
				iCountOrg += 4;

			// #line123
			// #12
			// Ȃǂr
			if (!isspace(szText[iCountOrg]))
				return CFG_ERR_OK;

			// sԍǂݍ
			tmpLineNum = strtol(&szText[iCountOrg], &p1, 10);
			if (p1 == &szText[iCountOrg])
				return CFG_ERR_OK;

			// # 123a
			// ȂǍsԍ̌ɗ]Ȃ̂Ăꍇr
			if (!isspace(*p1) && *p1 != '\0')
				return CFG_ERR_OK;

			// ǂݍ񂾍sԍ𔽉f
			m_iLogicalLineNum = tmpLineNum;

			// t@CT
			while (isspace(*p1))
				p1++;
			if (*p1 != '\"')
				return CFG_ERR_OK;
			p1++;
			p2 = strchr(p1, '\"');
			if (p2 == NULL)
				return CFG_ERR_OK;
			*p2 = '\0';

			// t@C𔽉f
			strncpy(m_szLogicalInputFile, p1, READ_MAX_PATH - 1);
			m_szLogicalInputFile[READ_MAX_PATH - 1] = '\0';

			return CFG_ERR_OK;
		}

		// ̓ǂݍ
		szText[iCount++] = c;
	}
}


// ǂݍ
int CRead::ReadString(int cDelimiter, char* szText, int& iCount)
{
	bool blEsc  = false;
	int c;

	for ( ; ; )
	{
		// Pǂݍ
		if ( (c = fgetc(m_fpRead)) == EOF )
		{
			return CFG_ERR_EOF;	// \EOF
		}

		// TCY`FbN
		if ( iCount >= READ_MAX_STATE - 1 )
		{
			return CFG_ERR_STATE_LEN;
		}

		// s`FbN
		if ( c == '\n' )
		{
			return CFG_ERR_CR;		// sȉs
		}

		// ̐ݒ
		szText[iCount++] = c;

		// \ ͖̎ɃXLbv
		if ( blEsc )
		{
			blEsc  = false;
			continue;
		}

		// \ ̃`FbN
		if ( c == '\\' )
		{
			blEsc  = true;
			continue;
		}

		blEsc  = false;

		// f~^Ȃ犮
		if ( c == cDelimiter )
		{
			return CFG_ERR_OK;
		}
	}
}


// ---------------------------------------------------------------------------
//  Copyright (C) 1998-2002 by Project HOS                                    
// ---------------------------------------------------------------------------
