// ---------------------------------------------------------------------------
//  Hyper Operating System V4 Advance RtBM[^[                           
//    KERNEL_DPC_QUE API ̏                                                  
//                                                                            
//                                    Copyright (C) 1998-2006 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defercd.h"
#include "dpcque.h"
#include "analyze.h"
#include "readcfg.h"


#define DPCQUE_QUECNT		0
#define DPCQUE_QUE			1


// RXgN^
CApiDpcQue::CApiDpcQue()
{
	// p[^[\ݒ
	m_iParamSyntax[0] = 0;		// Pƃp[^[
	m_iParams = 2;
}


// fXgN^
CApiDpcQue::~CApiDpcQue()
{
}


// IDԍ蓖
int CApiDpcQue::AutoId(void)
{
	return CFG_ERR_OK;
}


// APỈ
int CApiDpcQue::AnalyzeApi(const char* pszApiName, const char* pszParams)
{
	if ( strcmp(pszApiName, "KERNEL_DPC_QUE") == 0 )
	{
		if ( m_iObjs > 0 )
		{
			return CFG_ERR_MULTIDEF;
		}

		return AddParams(pszParams);
	}

	return CFG_ERR_NOPROC;
}


// cfgt@C`o
void  CApiDpcQue::WriteCfgDef(FILE* fp)
{
#if _KERNEL_SPT_DPC
	const char* pszQue;
	const char* pszQueCnt;

	// Rgo
	fputs(
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*                 DPC queue                  */\n"
		"/* ------------------------------------------ */\n\n"
		, fp);

	// p[^ǂݏo
	if ( m_iObjs > 0 )
	{
		pszQueCnt = m_pParamPacks[0]->GetParam(DPCQUE_QUECNT);
		pszQue    = m_pParamPacks[0]->GetParam(DPCQUE_QUE);
	}
	else
	{
		pszQueCnt = "32";		// w肪΃ftHgTCY
		pszQue    = "NULL";		// w肪NULL()
	}

	if ( strcmp(pszQue, "NULL") == 0 )
	{
		fprintf(
			fp,
			"VP_INT _kernel_dpc_queblk[(%s)];\n\n",
			pszQueCnt);
	}
#endif
}


// cfgt@CNo
void  CApiDpcQue::WriteCfgIni(FILE* fp)
{
#if _KERNEL_SPT_DPC
	const char* pszQue;
	const char* pszQueCnt;

	// p[^ǂݏo
	if ( m_iObjs > 0 )
	{
		pszQueCnt = m_pParamPacks[0]->GetParam(DPCQUE_QUECNT);
		pszQue    = m_pParamPacks[0]->GetParam(DPCQUE_QUE);
	}
	else
	{
		pszQueCnt = "32";		// w肪΃ftHgTCY
		pszQue    = "NULL";		// w肪NULL()
	}
	
	if ( strcmp(pszQue, "NULL") == 0 )
	{
		fprintf(
			fp,
			"\t_KERNEL_SYS_INI_DPC((VP)(_kernel_dpc_queblk), (UINT)sizeof(_kernel_dpc_queblk) / sizeof(VP_INT));\n");
	}
	else
	{
		fprintf(
			fp,
			"\t_KERNEL_SYS_INI_DPC((VP)(%s), (UINT)(%s));\n",
			pszQue, pszQueCnt);
	}
#endif
}


// end of file
