// ---------------------------------------------------------------------------
//  Hyper Operating System V4  RtBM[^[                           
//    DEF_TEX API ̏                                                      
//                                                                            
//                                    Copyright (C) 1998-2002 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defercd.h"
#include "deftex.h"
#include "analyze.h"
#include "readcfg.h"


#define DEFTEX_TSKID		0
#define DEFTEX_TEXATR		1
#define DEFTEX_TEXRTN		2



// RXgN^
CApiDefTex::CApiDefTex()
{
	// p[^[\ݒ
	m_iParamSyntax[0] = 0;		// Pƃp[^[
	m_iParamSyntax[1] = 2;		// 2p[^[̃ubN
	m_iParams = 2;
}

// fXgN^
CApiDefTex::~CApiDefTex()
{
}


// APỈ
int CApiDefTex::AnalyzeApi(const char* pszApiName, const char* pszParams)
{
	if ( strcmp(pszApiName, "DEF_TEX") == 0 )
	{
		return AddParams(pszParams);
	}

	return CFG_ERR_NOPROC;
}


// IDԍ蓖
int CApiDefTex::AutoId(void)
{
	return CFG_ERR_OK;
}


// cfgt@C`o
void  CApiDefTex::WriteCfgDef(FILE* fp)
{
	int  i;

	if ( m_iObjs <= 0 )
	{
		return;
	}

	// Rgo
	fputs(
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*          task exception objects            */\n"
		"/* ------------------------------------------ */\n"
		, fp);

	fprintf(
		fp,
		"\n/* task exception control block */\n"
		"const T_KERNEL_TEXCB_RAM kernel_texcb_ram[%d] =\n"
		"\t{\n",
		m_iObjs);

	// Rg[ubN(ROM)o
	for ( i = 0; i < m_iObjs; i++ )
	{
		fprintf(
			fp,
			"\t\t{0, (FP)(%s)},\n",
			m_pParamPacks[i]->GetParam(DEFTEX_TEXRTN));
	}
	fprintf(fp, "\t};\n");
}


// cfgt@Co
void  CApiDefTex::WriteCfgIni(FILE* fp)
{
	int i;

	// IuWFNg݃`FbN
	if ( m_iObjs == 0 )
	{
		return;
	}

	// o
	fputs(
		"\t\n\t\n"
		"\t/* initialize task exception handler */\n",
		fp);

	for ( i = 0; i < m_iObjs; i++ )
	{
		fprintf(
			fp,
			"\tkernel_tcb_ram_tbl[(%s) - TMIN_TSKID]->texcb = &kernel_texcb_rom[%d];\n",
			m_pParamPacks[i]->GetParam(DEFTEX_TSKID),
			i);
	}
}



// ---------------------------------------------------------------------------
//  Copyright (C) 1998-2002 by Project HOS                                    
// ---------------------------------------------------------------------------
