// ---------------------------------------------------------------------------
//  Hyper Operating System V4 Advance configurator
//    CRE_SEM API ̏
//
//                                    Copyright (C) 1998-2006 by Project HOS
//                                    http://sourceforge.jp/projects/hos/
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defercd.h"
#include "cresem.h"
#include "analyze.h"
#include "readcfg.h"


#define CRESEM_SEMID		0
#define CRESEM_SEMATR		1
#define CRESEM_SEMCNT		2
#define CRESEM_MAXSEM		3



// %jp{RXgN^}
CApiCreSem::CApiCreSem()
{
	// %jp{ftHg̍őIDݒ}
	m_iDefaultMaxId = _KERNEL_DEF_TMAX_SEMID;

	// %jp{p[^[\ݒ}
	m_iParamSyntax[0] = 0;		// %jp{Pƃp[^[}
	m_iParamSyntax[1] = 3;		// %jp{3p[^[̃ubN}
	m_iParams         = 2;
}

// fXgN^
CApiCreSem::~CApiCreSem()
{
}


// APỈ
int CApiCreSem::AnalyzeApi(const char* pszApiName, const char* pszParams)
{
	if ( strcmp(pszApiName, "CRE_SEM") == 0 )
	{
		return AddParams(pszParams);
	}
	else if ( strcmp(pszApiName, "KERNEL_MAX_SEMID") == 0 )
	{
		int iId;

		if ( m_iMaxId >= 0 )
		{
			return CFG_ERR_MULTIDEF;
		}

		if ( m_iResObj >= 0 )
		{
			return CFG_ERR_DEF_CONFLICT;
		}

		if ( (iId = atoi(pszParams)) < 0 )
		{
			return CFG_ERR_PARAM;
		}

		m_iMaxId = iId;

		return CFG_ERR_OK;
	}
	else if ( strcmp(pszApiName, "KERNEL_RSV_SEMID") == 0 )
	{
		int iId;

		if ( m_iMaxId >= 0 )
		{
			return CFG_ERR_DEF_CONFLICT;
		}

		if ( (iId = atoi(pszParams)) < 0 )
		{
			return CFG_ERR_PARAM;
		}

		if ( m_iResObj < 0 )
		{
			m_iResObj = 0;
		}
		m_iResObj += iId;

		return CFG_ERR_OK;
	}

	return CFG_ERR_NOPROC;
}


// ID `t@Co
void CApiCreSem::WriteId(FILE* fp)
{
	int i;

	if ( m_iMaxId <= 0 )
	{
		return;
	}

	// %jp{Rgo}
	fputs("\n\n/* Semaphore object ID definetion */\n\n", fp);


	// %jp{ID`o}
	for ( i = 0; i < m_iObjs; i++ )
	{
		if ( atoi(m_pParamPacks[i]->GetParam(CRESEM_SEMID)) == 0 )
		{
			fprintf(
				fp,
				"#define %s\t\t%d\n",
				m_pParamPacks[i]->GetParam(CRESEM_SEMID),
				m_iId[i]);
		}
	}

	// %jp{IDől`o}
	fprintf( fp,
		"\n"
		"#ifdef  TMAX_SEMID\n"
		"#undef  TMAX_SEMID\n"
		"#endif\n"
		"\n"
		"#define TMAX_SEMID\t\t%d\n\n", m_iMaxId );
}


// cfgt@C`o
void  CApiCreSem::WriteCfgDef(FILE* fp)
{
	int  i;

	if ( m_iMaxId <= 0 )
	{
		return;
	}

	// %jp{Rgo}
	fputs(
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*         create semaphore objects           */\n"
		"/* ------------------------------------------ */\n"
		, fp);

	if ( m_iMaxId > 0 )
	{
#if _KERNEL_SEMCB_ALGORITHM == _KERNEL_SEMCB_ALG_BLKARRAY
#if _KERNEL_SEMCB_SPLIT_RO
	// %jp{ubNzROM}
	{
		// %jp{RAMo}
		fprintf(fp, "\n_KERNEL_T_SEMCB _kernel_semcb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t{");
				WriteSemcbRam(fp, iObjNum);
				fprintf(fp, "},\n");
			}
			else
			{
				fprintf(fp, "\t\t{0},\n");
			}
		}
		fprintf(fp, "\t};\n");

		// %jp{ROMo}
		fprintf(fp, "\nconst _KERNEL_T_SEMCB_RO _kernel_semcb_ro_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t{");
				WriteSemcbRom(fp, iObjNum);
				fprintf(fp, "},\n");
			}
			else
			{
				fprintf(fp, "\t\t{0},\n");
			}
		}
		fprintf(fp, "\t};\n\n");
	}
#else
	// %jp{ubNz񁕓SEMCB}
	{
		// %jp{RAMo}
		fprintf(fp, "\n_KERNEL_T_SEMCB _kernel_semcb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t{");
				WriteSemcbRam(fp, iObjNum);
				WriteSemcbRom(fp, iObjNum);
				fprintf(fp, "},\n");
			}
			else
			{
				fprintf(fp, "\t\t{{0}, },\n");
			}
		}
		fprintf(fp, "\t};\n");
	}
#endif
#elif _KERNEL_SEMCB_ALGORITHM == _KERNEL_SEMCB_ALG_PTRARRAY
#if _KERNEL_SEMCB_SPLIT_RO
	// %jp{|C^zROM}
	{
		fprintf(fp, "\n");
		for ( i = 0; i < m_iObjs; i++ )
		{
			fprintf(fp, "const _KERNEL_T_SEMCB_RO _kernel_semcb_ro_blk_%d = {", m_iId[i]);
			WriteSemcbRom(fp, i);
			fprintf(fp, "};\n");
		}
		fprintf(fp, "\n");
		for ( i = 0; i < m_iObjs; i++ )
		{
			fprintf(fp, "_KERNEL_T_SEMCB _kernel_semcb_blk_%d = {", m_iId[i]);
			WriteSemcbRam(fp, i);
			fprintf(fp, "};\n");
		}
		fprintf(fp, "\n");
		fprintf(fp, "\n_KERNEL_T_SEMCB *_kernel_semcb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t&_kernel_semcb_blk_%d,\n", i);
			}
			else
			{
				fprintf(fp, "\t\tNULL,\n");
			}
		}
		fprintf(fp, "\t};\n");
	}
#else
	// %jp{|C^z񁕓SEMCB}
	{
		fprintf(fp, "\n");
		for ( i = 0; i < m_iObjs; i++ )
		{
			fprintf(fp, "_KERNEL_T_SEMCB _kernel_semcb_blk_%d = {", m_iId[i]);
			WriteSemcbRam(fp, i);
			WriteSemcbRom(fp, i);
			fprintf(fp, "};\n");
		}
		fprintf(fp, "\n");
		fprintf(fp, "\n_KERNEL_T_SEMCB *_kernel_semcb_tbl[%d] =\n\t{\n", m_iMaxId);
		for ( i = 1; i <= m_iMaxId; i++ )
		{
			int iObjNum = IdToObjNum(i);
			if ( iObjNum >= 0 )
			{
				fprintf(fp, "\t\t&_kernel_semcb_blk_%d,\n", i);
			}
			else
			{
				fprintf(fp, "\t\tNULL,\n");
			}
		}
		fprintf(fp, "\t};\n");
	}
#endif
#endif
	}

	// e[uTCYo
	fprintf(
		fp,
		"\nconst ID	_kernel_max_semid = %d;\n",
		m_iMaxId);
}


void CApiCreSem::WriteSemcbRam(FILE *fp, int iObj)
{
#if _KERNEL_SEMCB_QUE
	fprintf(fp, "{0}, ");														/* %jp{L[} */
#endif

#if _KERNEL_SEMCB_SEMCNT
	fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CRESEM_SEMCNT));		/* %jp{Z}tH̎} */
#endif
}


void CApiCreSem::WriteSemcbRom(FILE *fp, int iObj)
{
#if _KERNEL_SEMCB_SEMATR
	fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CRESEM_SEMATR));		/* %jp{Z}tH} */
#endif

#if _KERNEL_SEMCB_MAXSEM
	fprintf(fp, "(%s), ", m_pParamPacks[iObj]->GetParam(CRESEM_MAXSEM));		/* %jp{Z}tH̍ő厑} */
#endif
}



// cfgt@Co
void  CApiCreSem::WriteCfgIni(FILE* fp)
{
	if ( m_iMaxId <= 0 )
	{
		return;
	}

#if _KERNEL_SEMCB_ALGORITHM == _KERNEL_SEMCB_ALG_PTRARRAY && _KERNEL_SEMCB_SPLIT_RO
	if ( m_iObjs <= 0 )
	{
		return;
	}

	fprintf(fp, "\n\t/* semaphores */\n");
	for ( int i = 0; i < m_iObjs; i++ )
	{
		fprintf(fp, "\t_kernel_semcb_blk_%d.semcb_ro = &_kernel_semcb_ro_blk_%d;\n", m_iId[i], m_iId[i]);
	}
#endif
}


// cfgt@CNo
void  CApiCreSem::WriteCfgStart(FILE* fp)
{
}


// end of file
