/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{VXepAPI`}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "system/sysapi/sysapi.h"
#include "system/system/system_local.h"
#include "system/file/file.h"
#include "system/command/command.h"


/* VXeNX */
C_SYSTEM g_System;


static void System_BootProcess(VPARAM Param1, VPARAM Param2);


/* VXȅ */
void System_Initialize(const T_SYSTEM_INITIALIZE_INF *pInf)
{
	C_SYSTEM				*self;
	T_PROCESS_CREATE_INF	*pProcessInf;
	
	self = &g_System;

	/* VXeAPȈ */
	SysApi_Initialize(pInf->pSysMemBase, pInf->SysMemSize, pInf->SysMemAlign,
							pInf->pIoMemBase, pInf->IoMemSize, pInf->IoMemAlign);
	
	/* VXerp~[ebNX */
	self->hMtxSys = SysMtx_Create(SYSMTX_ATTR_NORMAL);

	/* VXeϐ̏ */
	self->hEvtProc     = SysEvt_Create(SYSEVT_ATTR_AUTOCLEAR);
	self->iProcHead    = 0;
	self->iProcTail    = 0;
	self->paWhiteBoard = NULL;

	/* t@CVXe */
	File_Initialize();
	
	/* R}hVXe */
	Command_Initialize();
	
	/* vZXpm */
	pProcessInf = (T_PROCESS_CREATE_INF *)SysMem_Alloc(sizeof(T_PROCESS_CREATE_INF));
	memset(pProcessInf, 0, sizeof(T_PROCESS_CREATE_INF));
	
	/* VXevZX̋N */
	pProcessInf->pszCommandLine = "[system]";
	pProcessInf->pfncEntry      = System_Process;			/* NAhX */
	pProcessInf->Param          = (VPARAM)self;				/* [U[p[^ */
	pProcessInf->StackSize      = pInf->SystemStackSize;	/* X^bNTCY */
	pProcessInf->Priority       = 1;						/* vZXDx */
	pProcessInf->hTerminal      = HANDLE_NULL;				/* ^[~i */
	pProcessInf->hConIn         = HANDLE_NULL;				/* R\[ */
	pProcessInf->hConOut        = HANDLE_NULL;				/* R\[o */
	pProcessInf->hStdIn         = HANDLE_NULL;				/* W */
	pProcessInf->hStdOut        = HANDLE_NULL;				/* Wo */
	pProcessInf->hStdErr        = HANDLE_NULL;				/* WG[o */
	pProcessInf->pszCurrentDir  = "/";						/* JgfBNg */
	Process_Constructor(&self->Process, NULL, pProcessInf);
	
	/* u[gvZX̋N˗ */
	pProcessInf->pszCommandLine = "[boot]";
	pProcessInf->pfncEntry      = pInf->pfncBoot;			/* NAhX */
	pProcessInf->Param          = pInf->BootParam;			/* [U[p[^ */
	pProcessInf->StackSize      = pInf->BootStackSize;		/* X^bNTCY */
	pProcessInf->Priority       = PROCESS_PRIORITY_NORMAL;	/* vZXDx */
	pProcessInf->hTerminal      = HANDLE_NULL;				/* ^[~i */
	pProcessInf->hConIn         = HANDLE_NULL;				/* R\[ */
	pProcessInf->hConOut        = HANDLE_NULL;				/* R\[o */
	pProcessInf->hStdIn         = HANDLE_NULL;				/* W */
	pProcessInf->hStdOut        = HANDLE_NULL;				/* Wo */
	pProcessInf->hStdErr        = HANDLE_NULL;				/* WG[o */
	pProcessInf->pszCurrentDir  = "/";						/* JgfBNg */
	System_RequestProc(System_BootProcess, (VPARAM)self, (VPARAM)pProcessInf);
}


/* u[gvZXVXevZX̎qvZXƂĊJn */
void System_BootProcess(VPARAM Param1, VPARAM Param2)
{
	C_SYSTEM				*self;
	T_PROCESS_CREATE_INF	*pProcessInf;

	self        = (C_SYSTEM *)Param1;
	pProcessInf = (T_PROCESS_CREATE_INF *)Param2;
	
	/* u[gvZXVXevZX̎qvZXƂĊJn */
	self->hBootProcess = Process_CreateEx(pProcessInf);
	
	/* vZXpJ */
	SysMem_Free(pProcessInf);
}



/* end of file */
