/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  system.h
 * @brief %jp{VXepAPI`}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "sysapi_local.h"


/* I/Op̕ԋp */
void SysIo_FreeIoMem(void *pMem)
{
	/* ʏ탁ƌp */
	if ( SysIo_pValMemHeap == NULL )
	{
		SysMem_Free(pMem);
		return;
	}
	
	/* I/Op̈ԋp */
	SysMtx_Lock(SysIo_hMtx);
	ValMemHeap_Free(SysIo_pValMemHeap, pMem);
	SysMtx_Unlock(SysIo_hMtx);
}



/* end of file */
