/** 
 *  Hyper Operating System  Application Framework
 *
 * @file process_setenvstring.c
 * @brief %jp{ϐݒ}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "process_local.h"



/** ϐݒ */
void Process_SetEnvString(HANDLE hProcess, const char *pszKey, const char *pszValue)
{
	C_PROCESS *self;
	
	/* w肪Ό݂̃vZXƂ */
	if ( hProcess == HANDLE_NULL )
	{
		hProcess = Process_GetCurrentHandle();
	}
	
	/* nhLXg */
	self = (C_PROCESS *)hProcess;
	
	/* ̈悪ΐ */
	if ( self->pEnv == NULL )
	{
		self->pEnv = Assoc_CreateEx(SysMem_GetMemHeap());
		if ( self->pEnv == NULL )
		{
			return;
		}
	}
	
	/* p[^ݒ */
	Assoc_Set(self->pEnv, pszKey, pszValue, strlen(pszValue)+1);
}


/* end of file */
