/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  handle.h
 * @brief %jp{nhIuWFNg}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "handleobj_local.h"
#include "system/process/process_local.h"


/* RXgN^ */
void HandleObj_Constructor(C_HANDLEOBJ *self, const T_HANDLEOBJ_METHODS *pMethods)
{
	C_HANDLEOBJ *pParent;

	/* z֐e[u̓o^ */
	self->pMethods = pMethods;
	
	/* VXe[hłȂ΃vZXɕRt */
	pParent = (C_HANDLEOBJ *)Process_GetCurrentHandle();
	if ( Process_IsSystemMode() || pParent == NULL )
	{
		/* VXevZXȂeō */
		self->pParent = NULL;
		self->pChild  = NULL;
		self->pNext   = self;
		self->pPrev   = self;
	}
	else
	{
		/* evZXɃN */
		self->pParent = pParent;
		self->pChild  = NULL;
		if ( pParent->pChild == NULL )
		{
			pParent->pChild = self;
			self->pNext     = self;
			self->pPrev     = self;
		}
		else
		{
			self->pNext = pParent->pChild;
			self->pPrev = self->pNext->pPrev;
			self->pNext->pPrev = self;
			self->pPrev->pNext = self;
		}
	}
}


/* end of file */
