/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  handleobj.h
 * @brief %jp{nhIuWFNg}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__handleobj_h__
#define __HOS__handleobj_h__


#include "system/handle/handle.h"


/* nhIuWFNgNX̃\bhe[u` */
typedef struct t_handleobj_methods
{
	void (*pfncClose)(HANDLE Handle);		/*  */
} T_HANDLEOBJ_METHODS;


/* nhIuWFNgNX` */
typedef struct c_handleobj
{
	const T_HANDLEOBJ_METHODS	*pMethods;

	struct c_handleobj			*pParent;		/* evZX̃nh */
	struct c_handleobj			*pChild;		/* vZXLnh */
	struct c_handleobj			*pNext;			/* ̃nh */
	struct c_handleobj			*pPrev;			/* Õnh */
} C_HANDLEOBJ;


#ifdef __cplusplus
extern "C" {
#endif

#define HandleObj_GetMethods(self)			((self)->pMethods)

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__handleobj_h__ */


/* end of file */
