/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  volumeobj.h
 * @brief %jp{{[IuWFNg{NX}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__volumeobj_h__
#define __HOS__volumeobj_h__


#include "system/handle/handleobj.h"
#include "system/file/drvobj.h"


/* {[IuWFNgNX{\bhe[u */
struct c_volumeobj;
typedef struct t_volumeobj_methods
{
	T_DRVOBJ_METHODS	DrvObjMethods;			/* DrvObjp */

	FILE_ERR (*pfncShutdown)(struct c_volumeobj *self);							/* foCX̃Vbg_E */
	FILE_ERR (*pfncMakeDir)(struct c_volumeobj *self, const char *pszPath);		/* TufBNg쐬 */
	FILE_ERR (*pfncRemove)(struct c_volumeobj *self, const char *pszPath);		/* t@C폜 */
} T_VOLUMEOBJ_METHODS;

typedef struct c_volumeobj
{
	C_DRVOBJ	DrvObj;							/* DrvObjp */
} C_VOLUMEOBJ;


/* nhϊ */
#define VOLUME_HANDLE2OBJ(hVolume)		((C_VOLUMEOBJ *)hVolume)


#ifdef __cplusplus
extern "C" {
#endif

HANDLE   VolumeObj_Create(void);												/**<  */
void     VolumeObj_Delete(HANDLE hVolume);										/**< 폜 */

FILE_ERR VolumeObj_Shutdown(C_VOLUMEOBJ *self);									/**< Vbg_E */
FILE_ERR VolumeObj_MakeDir(C_VOLUMEOBJ *self, const char *pszPath);				/**< TufBNg쐬 */
FILE_ERR VolumeObj_Remove(C_VOLUMEOBJ *self, const char *pszPath);				/**< t@C폜 */

#ifdef __cplusplus
}
#endif

#define VolumeObj_GetMethods(self)		((T_VOLUMEOBJ_METHODS *)HandleObj_GetMethods(&(self)->DrvObj))



#endif	/* __HOS__volumeobj_h__ */


/* end of file */
