/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  sysvol.h
 * @brief %jp{VXe{[}
 *
 *  %jp{[gfBNg /dev fBNgȂǁAVXẻz{[Ǘ}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__sysvol_h__
#define __HOS__sysvol_h__


#include "system/file/file.h"
#include "system/file/volumeobj.h"
#include "library/container/assoc/assoc.h"


#define DEVVOL_MAX_DEVICE		16
#define DEVVOL_MAX_NAME			16

/* foCX */
struct c_drvobj;
typedef struct t_sysvol_devinf
{
	HANDLE			hDriver;						/* foCXhCõnh */
	int				iAttr;							/* foCX̑ */
} T_SYSVOL_DEVINF;


/* VXe{[NX */
typedef struct c_sysvol
{
	C_VOLUMEOBJ		VolumeObj;		/* {[IuWFNgp */
	C_ASSOC			asDevice;		/* foCX̘Azz */
} C_SYSVOL;


#ifdef __cplusplus
extern "C" {
#endif

HANDLE   SysVol_Create(void);
void     SysVol_Delete(HANDLE hVolume);

FILE_ERR SysVol_AddDevice(HANDLE hSysVol, const char *pszName, HANDLE hDriver, int iAttr);	/* VXe{[ɃfoCXo^ */
FILE_ERR SysVol_RemoveDevice(HANDLE hSysVol, const char *pszName);							/* VXe{[ɓo^ꂽfoCXO */
HANDLE   SysVol_GetDevice(HANDLE hSysVol, const char *pszName);								/* VXe{[ɓo^ꂽfoCX */


#ifdef __cplusplus
}
#endif

#endif	/* __HOS__sysvol_h__ */



/* end of file */
