/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncfile.h
 * @brief %jp{@\tfoCXhCopt@CfBXNv^}
 *
 * %jp{t@CfBXNv^Ƃċ@\NX}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "syncfile_local.h"


static const T_FILEOBJ_METHODS SyncFile_FileObjMethods =
	{
		{File_Close},
	};


HANDLE SyncFile_Create(struct c_syncdrv *pSyncDrv, int iMode)
{
	C_SYNCFILE *self;
	
	/* m */
	if ( (self = (C_SYNCFILE *)SysMem_Alloc(sizeof(C_SYNCFILE))) == NULL )
	{
		return HANDLE_NULL;
	}
	
	/* RXgN^Ăяo */
	if ( SyncFile_Constructor(self, &SyncFile_FileObjMethods, pSyncDrv, iMode) != FILE_ERR_OK )
	{
		SysMem_Free(self);
		return HANDLE_NULL;
	}
	
	return (HANDLE)self;
}


/* end of file */
