/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncfile.h
 * @brief %jp{@\tfoCXhCo{NX}
 *
 * %jp{t@CfBXNv^Ƃċ@\NX}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "hosaplfw.h"
#include "syncdrv_local.h"
#include "system/system/system.h"


static void SyncDrv_SendSignalProc(VPARAM Param1, VPARAM Param2);


/** VOiʒm */
void SyncDrv_SendSignal(C_SYNCDRV *self, int iFactor)
{
	if ( SysCtx_IsIsr() )
	{
		/* ISŘĂяoȂAVXevZXoRŔ */
		System_RequestProc(SyncDrv_SendSignalProc, (VPARAM)self, (VPARAM)iFactor);	
	}
	else
	{
		/* łȂΒڎs */
		SyncDrv_SendSignalProc((VPARAM)self, (VPARAM)iFactor);
	}
}


/** VOizM */
void SyncDrv_SendSignalProc(VPARAM Param1, VPARAM Param2)
{
	C_SYNCDRV	*self;
	C_SYNCFILE	*pFile;
	int			iFactor;
	
	self    = (C_SYNCDRV *)Param1;
	iFactor = (int)Param2;
	
	
	SysMtx_Lock(self->hMtx);	/* NeBJZNVɓ */
	
	/* t@CIuWFNgɃVOi𑗂 */
	pFile = self->pFileHead;
	if ( pFile != NULL )
	{
		do
		{
			/* VOiݒ */
			SyncFile_SetSignal(pFile, iFactor);
			
			/* ɐi */
			pFile = pFile->pNext;
		} while ( pFile != self->pFileHead);
	}
	
	SysMtx_Unlock(self->hMtx);	/* NeBJZNVo */
}


/* end of file */
