/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncdrv.h
 * @brief %jp{@\tfoCXhCo̊{NX}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__syncdrv_local_h__
#define __HOS__syncdrv_local_h__


#include "syncdrv.h"
#include "system/file/drvobj_local.h"
#include "system/sysapi/sysapi.h"



/* v` */
#define SYNCDRV_FACTOR_WRITE		0
#define SYNCDRV_FACTOR_READ			1
#define SYNCDRV_FACTOR_IOCTL		2

#define SYNCDRV_FACTOR_NUM			3

struct c_syncfile;

/* foCXhCoIuWFNg{NX(ۃNX) */
typedef struct c_syncdrv
{
	C_DRVOBJ			DrvObj;				/**< DrvObjNXp */

	struct c_syncfile	*pFileHead;			/**< t@CIuWFNg̘A|C^ */
	
	SYSEVT_HANDLE		hMtx;				/**< r~[ebNX */
	
	int					iSyncFactorNum;		/**< v̐ */
	struct c_syncfile	**ppBusyFile;		/**< t@CIuWFNg */
} C_SYNCDRV;


#include "system/file/syncfile_local.h"


#ifdef __cplusplus
extern "C" {
#endif

FILE_ERR SyncDrv_Constructor(C_SYNCDRV *self, const T_DRVOBJ_METHODS *pMethods, int iSyncFactorNum);	/**< RXgN^ */
void     SyncDrv_Destructor(C_SYNCDRV *self);															/**< fXgN^ */

#define  SyncDrv_GetSyncFactorNum(self)		((self)->iSyncFactorNum)									/**< v擾 */

FILE_ERR SyncDrv_StartProcess(C_SYNCDRV *self, struct c_syncfile *pSyncFile, int iFactor);				/**< ̊Jn */
void     SyncDrv_EndProcess(C_SYNCDRV *self, int iFactor, VPARAM ErrCode);								/**< ̊ */
void     SyncDrv_SendSignal(C_SYNCDRV *self, int iFactor);												/**< VOȋM */

FILE_ERR SyncDrv_IoControl(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, int iFunc, void *pInBuf, FILE_SIZE InSize, const void *pOutBuf, FILE_SIZE OutSize);

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__drvobj_h__ */


/* end of file */
