/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncdrv.h
 * @brief %jp{@\tfoCXhCop{NX}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "syncdrv_local.h"


FILE_ERR SyncDrv_Constructor(C_SYNCDRV *self, const T_DRVOBJ_METHODS *pMethods, int iSyncFactorNum)
{
	int i;
	
	/* m */
	if ( (self->ppBusyFile = (C_SYNCFILE **)SysMem_Alloc(sizeof(C_SYNCFILE *) * iSyncFactorNum)) == NULL )
	{
		return FILE_ERR_NG;
	}

	/* r~[ebNX */
	self->hMtx = SysMtx_Create(SYSMTX_ATTR_NORMAL);

	/* oϐ */
	self->pFileHead      = NULL;
	self->iSyncFactorNum = iSyncFactorNum;
	for ( i = 0; i < self->iSyncFactorNum; i++ )
	{
		self->ppBusyFile[i] = NULL;
	}
	
	/* eNXRXgN^Ăяo */
	DrvObj_Constructor(&self->DrvObj, pMethods);
	
	return FILE_ERR_OK;
}


/* end of file */
